/*
    cast_test Version 0.0
    Copyright (C) 1998-1999 David Martnez Oliveira
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.    

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; see the file COPYING.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <signal.h>
#include <time.h>
#include <unistd.h>

#include <edma.h>

main(int argc,char *argv[])
{
  ESint32          res;
  OBJID            id;
  OBJID            id_sc,id_sc1;
  EPChar           SC_List[]= {"SUPER_CLASS",NULL};
  EPChar           SC_Id[]={"MIID",NULL};

  /* Initialize EDMA System*/
	EDMAInit();

  /* Put your C code here */
  printf ("\n Casting Test\n");
  printf ("+ Creating SUBCLASS2 object...\n");
  if ((id = edma_new_obj ("SUBCLASS2",NULL)) == -1)  {
    printf ("Can't create SUBCLASE2 object");
    EDMAEnd();
    exit(1);
  }
  edma_obj_report (id);
  edma_show_subobjects_up (id,"<ROOT>",0);
  printf ("+ Running Met1 in SUBCLASS2 object...\n");

  edma_met3 (id,"Met1");
  printf ("+ Upcasting object SUBCLASS2 to SUBCLASS1...\n");
  id_sc1 = edma_upcast_obj (id, "SUBCLASS1");
  edma_obj_report (id_sc1);

  printf ("+ Running Met1 in SUBCLASS1 object...\n");
  edma_met3 (id_sc1, "Met1");
  edma_met3 (id, "SUBCLASS1<Met1");
  edma_met3 (id, "SUBCLASS1>Met1");
  edma_obj_report (id);
  edma_show_subobjects_up (id, "******", 0);
  printf ("---------------------------------------\n");
  edma_show_subobjects_down (id, "********", 0);
  getchar ();

  printf ("+ Upcasting object SUBCLASS2 to SUPERCLASS...\n");
  id_sc = edma_upcast_obj (id, "SUPER_CLASS");
  printf ("+ Running Met1 in SUPER_CLASS object [%d]...\n",id_sc);
  edma_met3 (id_sc, "Met1");
  edma_met3 (id_sc, "SUPER_CLASS<Met1");

  printf ("+ Upcasting object SUBCLASS1 to SUPERCLASS...\n");
  id_sc = edma_upcast_obj (id_sc1, "SUPER_CLASS");
  printf ("+ Running Met1 in SUPER_CLASS object [%d]...\n",id_sc);
  edma_met3 (id_sc, "Met1");

  printf ("+ Downcasting object SUPER_CLASS to SUBCLASS2...\n");
  id_sc = edma_downcast_obj (id_sc1, "SUBCLASS2");
  printf ("+ Running Met1 in SUBCLASS2 object [%d]...\n",id_sc);
  edma_met3 (id_sc, "Met1");

  printf ("+ Now we add SUPER_CLASS to SUBCLASS2 object\n");
  printf ("+ We attache SUPER_CLASS in MIID anchor point\n");
  edma_mutate_obj ( edma_get_obj_pobj(id), SC_List, SC_Id);
  //ObjReport(id);
  printf ("+Upcast using anchor point\n");
  id_sc = edma_upcast_obj (id,"MIID");
  printf ("+ RUnning method Met1 in object MIID [%d]\n",id_sc);
  edma_met3 (id_sc,"Met1");
  edma_met3 (id,"MIID>Met1");
  edma_free_obj (id);

  /* Shutdown EDMA Suystem */
  EDMAEnd();
  return 0;
}
