/*
    met Version 0.0
    Copyright (C) 1998-1999 David Martnez Oliveira
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.    

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; see the file COPYING.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>

#include <edma.h>

#define MAX_INVOKE   50000

/* HELLO_WORLD TEST*/
//#define TEST1
/* Best case test */
//#define TEST2_1
/* Worst case test */
#define TEST2_2
/* Comparable case test*/
//#define TEST3

main(int argc,char *argv[])
{
  OBJID            id;
  ESint32          i, num;
  EReal64          d;
  time_t           t1, t2;

  /* Initialize EDMA System*/
  EDMAInit();

  /* Test 1: Using Hello_World */
#ifdef TEST1
  id = edma_new_obj ("HELLO_WORLD");
  edma_wprop3 (id, "str", "John");
#endif

  /* Test 2: Bad case to test effects of linear method lookup */
#ifdef TEST2_1  
   id = edma_new_obj ("CLASS_METADATA");
#endif
#ifdef TEST2_2
   id = edma_new_obj ("CLASS_METADATA");
#endif

  /* Test 3: FINAL for simple comparision with Java and C++ examples)*/
  /* Use FINAL for CPP/Java simple comparision (no further calls to EDMA API)*/
#ifdef TEST3
  id = edma_new_obj ("FINAL");
  edma_wprop3 (id, "name", "John Smith");
#endif

  for (i = 0; i < MAX_INVOKE; i++)
    /* Test 1:*/
#ifdef TEST1
    edma_met3 (id, "say");
#endif
    /* Test 2.1: CLASS_METADATA with close method */
#ifdef TEST2_1
    edma_met3 (id, "SetNMet", 10);
#endif
    /* Test 2.2:  CLASS_METADATA with last method (slower) */
#ifdef TEST2_2
    edma_met3 (id, "SetNSC", 5);
#endif 
    /* Test 3: FINAL with simple method (makes a call to edma_printf_obj) */
#ifdef TEST3
    edma_met3 (id, "display");
#endif  

  /* Shutdown EDMA Suystem */
  EDMAEnd();
  return 0;
}
