/*
    aop_log Version 0.0
    Copyright (C) 2004, 2005 David Martnez Oliveira
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.    

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; see the file COPYING.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
 */


#include <stdio.h>
#include <edma.h>

OBJID EDMAPROC
create_obj (OBJID id, EPChar classname)
{
  OBJID   obj;
  
  edma_printf ("[LOGGING] New object of class %s", classname);
  obj = edma_new_obj (classname);
  edma_wprop3 (id, "obj", obj);
  edma_printf ("[LOGGING] Object Identifier = %d", obj);
  return 0;
}

void EDMAPROC
destroy_obj (OBJID id)
{
  OBJID    obj;

  edma_rprop3 (id, "obj", &obj);
  edma_printf ("[LOGGING] Destroying object %d", obj);

  edma_free_obj (obj);

}

ESint32 EDMAPROC
write_prop (OBJID id, CLASSID cid, EPChar Prop, EPVoid val)
{
  OBJID   obj;

  edma_rprop3 (id, "obj", &obj);
  edma_printf ("[LOGGING] Writting propery %s on object %d", Prop, obj);
  edma_wprop3_pargs (obj, Prop, val);

  return 0;
}

ESint32 EDMAPROC
read_prop (OBJID id, CLASSID cid, EPChar Prop, EPVoid val)
{
  OBJID   obj;

  edma_rprop3 (id, "obj", &obj);
  edma_printf ("[LOGGING] Readding propery %s on object %d", Prop, obj);

  return edma_rprop3_pargs (id, Prop, val);
}

ESint32 EDMAPROC
run_method (OBJID id, CLASSID cid, EPChar met_name, EPVoid val)
{
  OBJID   obj;

  edma_rprop3 (id, "obj", &obj);
  edma_printf ("[LOGGING] Runnoing method %s on object %d", met_name, obj);
  return edma_met3_pargs (obj, met_name, NULL, 1, val);
}

int
main ()
{
  CLASSID   cid;
  OBJID     id;

  EDMAInit ();

  cid = edma_idf_get_free_class_id (EDMA_LOCAL_CLASS);

  edma_idf_set_class_name (cid, "LOG_PROXY");
  edma_idf_set_class_namespace (cid, "LOCAL");
  edma_idf_set_class_version (cid, 0, 0);

  edma_add_local_class_property (cid, "obj", DT_EOBJECT, E_L, 0);
  edma_add_local_class_method (cid, "WProp3", "", (PPROC) write_prop, 0, 0, 0);
  edma_add_local_class_method (cid, "RProp3", "", (PPROC) read_prop, 0, 0, 0);
  edma_add_local_class_method (cid, "Met3",   "", (PPROC) run_method, 0,0,0);
  edma_add_local_class_method (cid, "NewObj",   "", (PPROC) create_obj, 0,0,0);
  edma_add_local_class_method (cid, "FreeObj",   "", (PPROC) destroy_obj, 0,0,0);

  edma_idf_set_class_attribs (cid, 1, 0, 0);

  edma_idf_set_class_id (cid);

  id = edma_new_obj ("LOG_PROXY:HELLO_WORLD");

  edma_wprop3 (id, "str", "Hoooooola");
  edma_wprop3 (id, "num", 123);
  edma_met3 (id, "say");

  edma_free_obj (id);

  EDMAEnd ();
}
