/*
    ap_test Version 0.0
    Copyright (C) 1998-2005 David Martnez Oliveira
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.    

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; see the file COPYING.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <signal.h>
#include <time.h>
#include <unistd.h>

#include <edma.h>

int
main(int argc,char *argv[])
{
  OBJID            id;
  OBJID            id_sc,id_sc1;
  POBJ             pObj;

  /* Initialize EDMA System*/
  EDMAInit ();

  /* Put your C code here */
  printf ("%s", "\nAnchor Point Test\n");
  if ((id = edma_new_obj ("AP_TEST")) == -1)  
    {
      EDMAEnd ();
      exit (1);
    }

  /* Build a complex class hierarchy using On-Demand Inheritance */
  edma_wprop3 (id, "Id", "Father Object");
  edma_wprop3 (id, "AP_TEST@SUPER>Id", "Super 1");
  edma_wprop3 (id, "SUPER>AP_TEST@SUPER>Id", "Super 1.0");
  edma_wprop3 (id, "SUPER>AP_TEST@SUPER1>Id", "Super 1.1");
  edma_wprop3 (id, "SUPER>SUPER1>AP_TEST@MOST_TOP>Id", "Most Top");
  edma_wprop3 (id, "SUPER>SUPER>AP_TEST@MOST_TOP2>Id", "Most Top 2");
  edma_wprop3 (id, "SUPER>SUPER1>AP_TEST@MIDDLE<Id", "Middle");


  /* Get a reference to subobject at anchor point MOST_TOP */
  id_sc = edma_upcast_obj (id, "MOST_TOP"); 

  /* Show information of subobject at MOST_TOP anchor point */
  edma_obj_report (id_sc);

  /* Run some methods with specific anchor points */
  edma_met3 (id_sc, "display"); 
  edma_met3 (id, "SUPER>SUPER1>display");
  edma_met3 (id, "MIDDLE>display");
  edma_met3 (id_sc,"AP_TEST<display");
  printf ("%s", "\n-----------------------------------------------------\n");

  /* Show subobject up tree for object id */
  edma_show_subobjects_up (id, "Root", 0);
  printf ("%s", "\n-----------------------------------------------------\n");

  /* Show subobject down three for object id */
  edma_show_subobjects_down (id_sc,"Root", 0);
  /* Rename subclass anchor point AP_TEST in object id_sc to SUPER*/
  edma_rename_subclass_ap (id_sc, "AP_TEST", "SUPER");
  printf ("\n-----------------------------------------------------\n");

  /* Show hierarchy again to show change of name */
  printf ("%s", "Subclass of object Root changed from AP_TEST to SUPER");
  edma_show_subobjects_down (id_sc,"Root", 0);
  printf ("%s", "\n-----------------------------------------------------\n");

  /* Use classpath operators to edit anchor points */
  /* Operator | allows to set at one time anchor points for up and down links */
  edma_met3 (id, "AP_TEST@SUPER2|INNER1>display");
  printf ("%s", "\n-----------------------------------------------------\n");
  edma_show_subobjects_up (id, "ROOT", 0);
  printf ("%s", "\n-----------------------------------------------------\n");

  /* Get another reference to other object in the hierarchy and perform some other ops*/
  id_sc = edma_upcast_obj (id, "SUPER2");
  edma_show_subobjects_down (id_sc, "ROOT", 0);
  printf ("%s", "\n-----------------------------------------------------\n");

  printf ("%s", "-----------------------------------------------------\n");
  edma_met3 (id, "AP_TEST@OINNER1|OSUPER1<display");
  printf ("%s", "\n-----------------------------------------------------\n");


  id_sc = edma_downcast_obj (id, "OINNER1");
  edma_show_subobjects_up (id_sc, "ROOT", 0);
  printf ("%s", "\n-----------------------------------------------------\n");
  edma_show_subobjects_down (id, "ROOT", 0);
  edma_wprop3 (id, "OINNER1<Id", "Root Object");
  edma_met3 (id, "display");

  printf ("%s", "\n=====================================================\n");
  edma_met3 (id, "TEST@SUPER>display");
  edma_met3 (id, "TEST@OINNER1<display");
  printf ("%s", "\n=====================================================\n");

  /* Set object id to final so no more on-demand inheritance is allowed*/
  edma_set_obj_final (id,1);
  /* Comand bellow will fail */
  edma_met3 (id, "AP_TEST@UPFINAL|DOWNFINAL>display");

  edma_free_obj (id);

  printf ("\n-----------------------------------------------------\n");
  /* Shutdown EDMA Suystem */
  EDMAEnd();
  return 0;
}
