/*
    ap_overwrite Version 0.0
    Copyright (C) 1998-2005 David Martnez Oliveira
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.    

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; see the file COPYING.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <signal.h>
#include <time.h>
#include <unistd.h>

#include <edma.h>

int
main(int argc,char *argv[])
{
  OBJID            id;
  OBJID            id_sc,id_sc1;
  POBJ             pObj;

  /* Initialize EDMA System*/
  EDMAInit ();

  /* Put your C code here */
  printf ("\nAnchor Point Test\n");
  if ((id = edma_new_obj ("AP_TEST")) == -1)  
    {
      EDMAEnd();
      exit(1);
    }

  /* Add a new subclass to object if of class GAP at anchor point INNER */
  edma_met3 (id, "GAP@INNER<gap");
  /* Show report of current object */
  edma_obj_report (id);

  /* Override anchor point INNER with a new object of class DOG */
  edma_met3 (id, "DOG@!INNER<display"); 

  /* Show the changes in the hierarchy */
  edma_obj_report (id);
  edma_show_subobjects_down (id, "---", 2);
  id_sc = edma_downcast_obj (id, "INNER");
  edma_obj_report (id_sc);
  edma_show_subobjects_up (id_sc, "---", 2);

  /* Finished. Destroying object */
  edma_free_obj (id);

  printf ("\n-----------------------------------------------------\n");
  printf ("\n-----------------------------------------------------\n");

  /* Repeat the test using superclasses*/
  id = edma_new_obj ("AP_TEST"); 

  edma_met3 (id, "GAP@SUPER>gap");
  edma_obj_report (id);
  edma_show_subobjects_up (id, "****", 2);

  edma_met3 (id, "DOG@!SUPER>display"); 
  edma_obj_report (id);
  edma_show_subobjects_up (id, "---", 2);
  id_sc = edma_upcast_obj (id,"SUPER");
  edma_obj_report (id_sc);
  edma_show_subobjects_down (id_sc, "---", 2);
  edma_free_obj (id);  
  /* Shutdown EDMA Suystem */
  EDMAEnd ();
  return 0;
}
