/*
 * EDMA: Entorno de Desarrollo Modular y Abierto
 * Object Oriented and Componetware Framework
 * Copyright (C) 1998, 2002, 2003, 2004, 2005 David Martnez Oliveira
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.

 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/ 
/*
 * Servidor de visualizacion en consola
 * 3 de Julio de 1997
 *
 * Fichero de cabecera
 * Compilador  :Cygnus-WIN32 beta 18
 * Descripcion :
 *       Pruebas de herramientas de sincronizacion WIN32 para
 *       EDMA32
 *
 * */


#ifndef VSERV_H
#define VSERV_H

#include <stdio.h>
#include <string.h>
#include "portable.h"

#ifdef __cplusplus
extern "C"{
#endif

typedef struct
{
   HMEM     Mutex;                      // Acceso en exclusion mutua
   HMEM     Sync;                       // Objeto de sincronizacion

   EChar    Msg[200];
   ESint32	Color;
   ESint32	Size;
   HMEM     h;                          // Para borrado de memoria
   char     full;
   EChar	Init;					// Indica si la consola est inicializada
} VSERV;

// Esta funcin crea estructura compartida y se mapea en el
// espacio de direccionamiento del proceso que la llama
/*
EPVoid InitServer(EPChar);
EPVoid MapServer(EPChar);
EUint32 FreeServer (VSERV*);
EUint32 UnmapServer (VSERV*);
*/
EUint32 vDrawString(VSERV*,EPChar);
/*
EUint32 vDrawStringEx(VSERV*,EPChar,ESint32,ESint32);
EUint32 vWaitString(VSERV*,EPChar,EPSint32,EPSint32);
EUint32	IsInitialized(EPChar);
*/
#ifdef __cplusplus
}
#endif
#endif
