/*
 * EDMA: Entorno de Desarrollo Modular y Abierto
 * Object Oriented and Componetware Framework
 * Copyright (C) 1998, 2002, 2003, 2004, 2005 David Martnez Oliveira
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.

 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/ 
/*
 * Entorno de Desarrollo Modular y Abierto
 * Version 0.3r1
 * (c) David Martnez Oliveira
 * 
 * Extensin de primitivas de nivel 3
 * 
 * Revisiones:
 * 10/12/1997
 * Creacin del fichero
 *----------------------------------
 * Febraury, 7th-19th, 2001
 * Code cleanup and comment tranlation
 * -----------------------------------------------
 * November, 18th, 2001
 * Compile warnnings removal
 * ---------------------------------------------------
 * March, 2nd, 2002
 * Code cleanup
 * ------------------------------------------------------
 * May, 13th, 2002
 * Fix SIU invocation. We only must return an error if we don't
 * found the method/property and we don't reach a SIU proxy object
 * ----------------------------------------------------------------------
 * April, 2nd, 2003
 * Changes to support changes to OBJ struct
 * -----------------------------------------------------------------------
 * May, 10th, 2003
 * Modification to support changes to internal class structures
 * --------------------------------------------------------------------------
 * July, 17th, 2003
 * Fixed issue with va_list and gcc-3.x
 * Method parameters are now retrieved using va_arg macro instead of referencing
 * directly va_start pointer. This should be portable almost for code generated by
 * the same compiler.
 * XXXXXXXXXXXXXXX CAUTION XXXXXXXXXXXXX CAUTION XXXXXXXXXXXXXXXXXXXXX
 * The changes haven't be fully tested against SIU proxies fall backs
 * XXXXXXXXXXXXXXX CAUTION XXXXXXXXXXXXX CAUTION XXXXXXXXXXXXXXXXXXXXX
 * This part of code will get platform-dependant due to ABI incompatibilities
 * among compilers and machines
 * ---------------------------------------------------------------------------------
 * August, 28th, 2003
 * Removing old unused code in edma_met3_pargs, and trying some optimizations
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include "portable.h"
#include "vglobal.h"
#include "pri1.h"
#include "pri3.h"
#include "misc.h"
#include "obj.h"

#include "anchor_points.h"
#include "helper.h"
#include "error.h"
#include "locators.h"

#include "hotswap.h"

/*_----------------------------------------------------------------------_*/
/* Level 3 primitives that get parameters from a pointer               
 * The basic primitives really can call these functions.... 
 * we must to change this
 */

/* edma_met3_pargs
 *   Effective execution of method. Required to be used from SIU proxies
 */

ESint32 EDMAPROC
edma_met3_pargs (OBJID IdObj, EPChar Id1, EPChar Sig, ESint32 virt, EPVoid p)
{
  OBJID     iObj, r;
  ESint32   indx, pos, i;
  ESint32   Tipo;
  POBJ      pObj;
  PPROC     Func = NULL;
  ESint32   ret_val;
  CLASSID   cid;
  va_list   param;
  EPUint32   p2[16];
  
  param = (va_list)p;
  /* First check for valid object identifier*/
  if ((edma_check_obj_id (IdObj, "edma_met3_pargs")) == -1) 
    return -1;

  /* Do not use signature*/
  r = _edma_locate_method (IdObj, Id1, Sig, &pos, &indx);

  /* We arrive here with the real object and Method index to execute.  */
  if (r == -1)
    return _edma_system_exception ("[edma_met3_pargs] Can't run method '%s'"
				   " on object %d of class '%s'", 
				   Id1, IdObj, gClass[gObj[IdObj]->IdClass]->ClassName);

  /* If a classpath was specified and we reach the same object -> 
     throw an exception*/
  if ((r == IdObj) && pos)
    {
      edma_printf_err ("[edma_met3_pargs] Inheritance cycle detected, running "
		       "method '%s' in object %ld of class '%s'", Id1, IdObj,
		       gClass[gObj[IdObj]->IdClass]->ClassName);
      return -1;
    }

  pObj = gObj[r];    
  Tipo = pObj->IdClass;

  if (indx == -1) 
    { /* If no subobject was found */
      if (pObj->IdSIU != -1) 
	{ /* If the subobject is in a SIU system, let it go*/
	  ret_val = (ESint32) edma_met3 (IdObj, "Met3", 
					 pObj->IdSIU, Id1 + pos, p);
	  return ret_val;
	}
      
      return _edma_system_exception ("[edma_met3_pargs] Method '%s' "
				     "not defined in class '%s'", 
				     Id1, gClass[Tipo]->ClassName);
    } 
  else 
    { /* We have a valid subobject*/
      pObj->last_met = indx;
      if ((pClass[Tipo]->Met[indx].Virtual) && (virt == 1)) 
	{
	  /* We look for the virtual method we want toi execute */
	  for (i = 0; i < gClass[Tipo]->nMetVir; i++)
	    if (pObj->vTable[i].Ind == indx)
	      break;
	  /* if it's overriden by an object*/

	  if (pObj->vTable[i].Flag == 1) 
	    {
	      /* Allow multiple override execution*/
	      iObj = ((POBJ)pObj->vTable[i].Obj)->IdObj;
	      Func = pObj->vTable[i].Func;
	      /* Store current classid for run-time stack tracking.
	       * We do not go through the object because, in the case of an exception object
	       * object may not exists after edma_met3 execution*/
	      cid = gObj[iObj]->IdClass;
	      pClass[cid]->nRef++;
	      
	      /* Store parameter list in an array. Thread parameters as the bigger supported type*/
	      p2[0] = va_arg(param,long*);
	      p2[1] = va_arg(param,long*);
	      p2[2] = va_arg(param,long*);
	      p2[3] = va_arg(param,long*);
	      p2[4] = va_arg(param,long*);
	      p2[5] = va_arg(param,long*);
	      p2[6] = va_arg(param,long*);
	      p2[7] = va_arg(param,long*);
	      p2[8] = va_arg(param,long*);
	      
	      /* Update stack execution */
	      _edma_stack_execution_add_obj (iObj);
	      
	      /* Forward function call with parameter regeneration */
	      ret_val = 
		(ESint32) Func (iObj,  pObj->vTable[i].Id,
				p2[0], p2[1], p2[2], p2[3], 
				p2[4], p2[5], p2[6], p2[7], p2[8]);
	      
	      _edma_stack_execution_del_obj (iObj);
	      
	      pClass[cid]->nRef--;
	      return ret_val;
	    }
	  Func = pObj->vTable[i].Func;
	  pObj = ((POBJ) pObj->vTable[i].Obj);
	  if (pObj == NULL)
	    iObj = -1;
	  else
	    iObj = pObj->IdObj;
	} 
      else 
	{
	  Func = (PPROC) pClass[Tipo]->met_func[indx].Func;
	  iObj = r;
	}
      /* Store current classid for run-time stack tracking.
       * We do not go through the object because, in the case of an exception object
       * object may not exists after edma_met3 execution*/

      cid = gObj[iObj]->IdClass;
      pClass[cid]->nRef++;

       /* Store parameter list in an array. Thread parameters as the bigger supported type*/
       p2[0] = va_arg(param,long*);
       p2[1] = va_arg(param,long*);
       p2[2] = va_arg(param,long*);
       p2[3] = va_arg(param,long*);
       p2[4] = va_arg(param,long*);
       p2[5] = va_arg(param,long*);
       p2[6] = va_arg(param,long*);
       p2[7] = va_arg(param,long*);
       p2[8] = va_arg(param,long*);

       /* Update stack execution */
       _edma_stack_execution_add_obj (iObj);

       /* Forward function call with parameter regeneration */
       ret_val = 
	 (ESint32) Func (iObj, p2[0], p2[1], p2[2], p2[3], 
			 p2[4], p2[5], p2[6], p2[7], p2[8]);

       _edma_stack_execution_del_obj (iObj);

       pClass[cid]->nRef--;
       return ret_val;
    }
  /* Virtual Objects support is removed */
  edma_printf ("[emda_met3_pargs] You shouldn't been seeing this message. "
	       "Method: %s", Id1);
  return 0;
}

/* Write property */

/* edma_wprop3_pargs
 *   Effective write of property. This function must be used from SIU proxies
 */

ESint32 EDMAPROC
edma_wprop3_pargs (OBJID IdObj, EPChar Id1, EPVoid p)
{
  OBJID     r;
  ESint32   indx, pos;
  ESint32   Tipo;
  EPChar    Id = NULL;
  POBJ      pObj;
  va_list   param;

  param = (va_list)p;
  /* First check for valid object identifier*/
  if ((edma_check_obj_id (IdObj,"edma_write_prop3")) == -1) 
    return -1;

  r = _edma_locate_property (IdObj, Id1, &pos, &indx);

  /* We arrive here with the real object and Property index.  */
  if (r == -1) 
    return _edma_system_exception ("[edma_wprop3_pargs] Can't write "
				   "Property '%s' on Object %d "
				   "of class '%s'", Id1, IdObj, 
				   gClass[gObj[IdObj]->IdClass]->ClassName);
  
  pObj = gObj[r];
  Tipo = pObj->IdClass;

  if (indx == -1) 
    { /* If no subobject was found */
      if (pObj->IdSIU != -1) 
	{ /* If the subobject is in a SIU system, let it go*/
	  /*******************************************************************************/
	  /* XXXXXXXXXXXXXXXXXXXX CODE DON'T TESTED  ***** CAUTION ***** XXXXXXXXXXXXXXX  */
	  /*******************************************************************************/
	  return (ESint32) edma_met3 (IdObj, "WProp3", 
				      //pObj->IdSIU, Id1 + pos, va_arg(param,long*));
				      pObj->IdSIU, Id1 + pos, p);
	}
      return _edma_system_exception ("[edma_wprop3_pargs] Property '%s' "
				     "not defined in class '%s'",
				     Id, gClass[Tipo]->ClassName);
    } 
  else 
    { /* We have a valid subobject*/
      _edma_wprop1_pargs (pObj->IdObj, indx, p);
    }
  return 0;
}

/* Read property */
/* edma_rprop3_pargs
 *   Effective read of a property. This function must be used from SIU proxies
 */

ESint32 EDMAPROC
edma_rprop3_pargs (OBJID IdObj, EPChar Id1, EPVoid p)
{
  OBJID     r;
  ESint32   indx ,pos;
  ESint32   Tipo;
  EPChar    Id = NULL;
  POBJ      pObj;
  va_list   param;

  /* First check for valid object identifier*/
  if ((edma_check_obj_id (IdObj,"edma_write_prop3")) == -1) 
    return -1;

  r = _edma_locate_property (IdObj, Id1, &pos, &indx);

  /* We arrive here with the real object and Property index */
  if (r == -1) 
    return _edma_system_exception ("[edma_rprop3_pargs] Can't write "
				   "Property '%s' on Object %d "
				   "of class '%s'", Id1, IdObj, 
				   gClass[gObj[IdObj]->IdClass]->ClassName);
  
  pObj = gObj[r];  
  Tipo = pObj->IdClass;

  if (indx == -1) 
    { /* If no subobject was found */
      if (pObj->IdSIU != -1) 
	{ /* If the subobject is in a SIU system, let it go*/
	  /*******************************************************************************/
	  /* XXXXXXXXXXXXXXXXXXXX CODE DON'T TESTED  ***** CAUTION ***** XXXXXXXXXXXXXXX  */
	  /*******************************************************************************/
	  param = (va_list) p;
	  return (ESint32) edma_met3 (IdObj, "RProp3", 
				      pObj->IdSIU, Id1 + pos, p);
				      //pObj->IdSIU, Id1 + pos, va_arg(param,long*));
	}
      return _edma_system_exception ("[edma_rprop3_pargs] Property '%s' "
				     "not defined in class '%s'",
				     Id, gClass[Tipo]->ClassName);
    } else { /* We have a valid subobject*/
      _edma_rprop1_pargs (pObj->IdObj, indx, p);
    }
  return 0;
}

