/*
 * EDMA: Entorno de Desarrollo Modular y Abierto
 * Object Oriented and Componetware Framework
 * Copyright (C) 1998, 2002, 2003, 2004, 2005 David Martnez Oliveira
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.

 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/ 

/**********************************************************
 * Entorno de Desarrollo Modular y Abierto
 * (c) David Martnez Oliveira
 * Vigo 17 de Octubre de 1996
 *
 * Versin 0.3r1
 *---------------------------------------------------------
 * Mdulo caecera para funciones miscelnea
 *********************************************************
 * Febraury, 24th, 2001
 * Code cleanup and comment translation
 * ---------------------------------------------------------
 * Added EBufferRealloc function
*/

/* Prototypes */
#ifndef MISC_H
#define MISC_H

#include "portable.h"
#include "tobj.h"
#include "ttypes.h"
#include "systyp.h"

#ifdef __cplusplus
extern "C"{
#endif
  EUint32 EDMAPROC edma_print (EPChar);
  EUint32 EDMAPROC edma_printf_obj (OBJID IdObj,EPChar f,...);
  EUint32 EDMAPROC edma_printf (EPChar f,...);
  EUint32 EDMAPROC edma_printf_err (EPChar f,...);
  EUint32 EDMAPROC edma_printf_dbg (EUint32 l,OBJID IdObj,EPChar f,...);

  EUint32 EDMAPROC edma_set_app_name (EPChar);
  EUint32 EDMAPROC edma_set_debug_level (EUint32 l);
  EPChar  EDMAPROC edma_get_system_path ();

  ESint32 EDMAPROC edma_buffer_alloc (EDMAT_BUFFER *,EUint32);
  ESint32 EDMAPROC edma_buffer_free (EDMAT_BUFFER*);   
  ESint32 EDMAPROC edma_buffer_realloc (EDMAT_BUFFER*,EUint32);

  /* Dictionaries */
  ESint32 EDMAINLINE edma_dict_map_string (EDMA_DICT, EPChar);
  EDMA_DICT EDMAPROC edma_dict_new (ESint32);
  ESint32 EDMAPROC edma_dict_free (EDMA_DICT);
  ESint32 EDMAPROC edma_dict_add_entry (EDMA_DICT, EPChar, ESint32);
  ESint32 EDMAPROC edma_dict_get_index (EDMA_DICT, EPChar);
  ESint32 EDMAPROC edma_dict_get_next_index (EDMA_DICT, EPChar, ESint32*);
  
#ifdef __cplusplus
}
#endif
#endif
