/*
 * EDMA: Entorno de Desarrollo Modular y Abierto
 * Object Oriented and Componetware Framework
 * Copyright (C) 1998, 2002, 2003, 2004, 2005 David Martnez Oliveira
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.

 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/ 
/*
 * Febraury, 7th, 2001
 * Code cleanup and comment translation
 * --------------------------------------------------------
 * October, 14th,2001
 * Added PRealloc function
 * ---------------------------------------------------------
 * November, 18th, 2001
 * Now temporally file to get a uinique key are created in TMPDIR
 * a constant defined in conts.h
 * 
 * Compile warnnings removal
 * ------------------------------------------------------------
 * march, 2nd, 2002
 * Code cleanup
 */ 

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include "portable.h"
#include "const.h"

#include "shmem.h"
EChar   Buffer[1024];

EUint32  n_palloc = 0;
EUint32  n_pget = 0;
EUint32  n_pfree = 0;
EUint32  n_prealloc = 0;

/* edma_salloc
 *   Shared Memory version of malloc
 */

HMEM EDMAPROC 
edma_salloc (EUint32 size, EPChar n) 
{
  EUint32   a,shmflg,f;
  EChar     name[EDMA_PATH_LEN];
  key_t     k;
  
  /* We create a file for filemapping shared memory */
  strncpy (name, TMPDIR, EDMA_PATH_LEN);
  strncat (name, "/", EDMA_PATH_LEN);
  strncat (name, n, EDMA_PATH_LEN);
  f = open (name, O_WRONLY | O_CREAT | O_TRUNC);
  if (f == -1) 
    {
      if (errno != EEXIST) 
	{
	  perror ("Create File");
	  return -1;
	}
    }
  
  chmod (name, S_IRWXU | S_IRWXG | S_IRWXO);
  if ((k = ftok (name, 0)) == -1)
    {
      perror ("[edma_salloc] (ftok)");
      return -1;
    }

  shmflg = 0;
  
  a = shmget (k,size, IPC_CREAT | 0777);
  if ((a == -1) && (errno != EEXIST)) 
    {
      printf ("\n[edma_salloc] ERROR in shared block : %s (key:%d|size:%ld)",
	      name, k, size);
      printf ("\n ");
      perror("[edma_salloc] (shmget):");
      return -1;
    }
  close (f);
  return ((HMEM)a);
}

/* edma_sget
 *   Used to provide support to system managing memory with handlers
 */

EPVoid EDMAPROC 
edma_sget (HMEM a) 
{
  EPVoid     p;
  
  p = shmat ((EUint32) a, 0, SHM_RND);
  if ((int)p == -1) 
    {
      perror("[edma_sget] :");
      return (EPVoid)-1;
    }
  
  return p;
}

/* edma_sunget
 *    Deattaches shared memory for process 
 *    Used to provide support to systems which handler-based memory management
 */
EPVoid EDMAPROC 
edma_sunget (EPVoid p) 
{
  EUint32    i;
  
  i = shmdt(p);
  if (i == -1) 
    {
      perror ("[edma_sunget] :");
      return (EPVoid)-1;
    }
  
  return p;
}

/* edma_sfree
 *  Shared version of free
 */

void EDMAPROC 
edma_sfree (HMEM i, EPVoid p) 
{
  ESint32         a;
  struct shmid_ds buf;
  
  a = shmctl (i, IPC_RMID, &buf);
  if (a == -1) 
    {
      perror("[edma_sfree] (IPC_RMID):");
      return;
    }
  /* Here we should delete the file */
}

/************************************************************
 * Private memory management 
 *************************************************************/

/* edma_palloc
 *   Normal malloc, with data initialisation
 */

HMEM EDMAPROC 
edma_palloc (EUint32 size) 
{
  EPVoid p;
  EPChar t;
  EUint32 i;
  
  p = malloc (size);
  t = (EPChar) p;
  if (p != NULL)
    for (i = 0; i < size; i++) *(t + i) = 0;

  n_palloc++;
  return ((HMEM) p);
}

/* edma_prealloc
 *  Normal Realloc, simple wrapper
 */

HMEM EDMAPROC 
edma_prealloc (HMEM a, EUint32 new_size) 
{
  if (a == 0)
    n_palloc++;
  else
    n_prealloc++;

  a = (HMEM) realloc ((EPVoid) a, new_size);

  return a;
}

/* edma_pget
 *   Function to support handler-based memory management systems
 */

EPVoid EDMAPROC 
edma_pget (HMEM a) 
{
  n_pget++;
  return (EPVoid)a;
}

/* edma_pfree
 *  Simple free function
 */

void  EDMAPROC 
edma_pfree (HMEM a, EPVoid p) 
{
  n_pfree++;
  if (p == NULL)
    return;
  free (p);
}

void EDMAPROC
edma_show_pmem ()
{
  printf ("palloc   : %ld times\n", n_palloc);
  printf ("pget     : %ld times\n", n_pget);
  printf ("prealloc : %ld times\n", n_prealloc);
  printf ("pfree    : %ld times\n", n_pfree);
}
      
