/*
 * EDMA: Entorno de Desarrollo Modular y Abierto
 * Object Oriented and Componetware Framework
 * Copyright (C) 1998, 2002, 2003, 2004, 2005 David Martnez Oliveira
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.

 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/ 
/*
 * Entorno de Desarrollo Modular y Abierto
 * Version 0.2r2
 * (c) David Martnez Oliveira
 * 
 * Module   : INIMAN
 * Type     : Header file
 * Category : System dependency
 * Description :
 *    Simulates WIN32 API functios for managing Windows .INI files-like
 * 
 * Revisions:
 * 15/10/1997
 *   Creation
 * -----------------------------------------------
 * Febraury, 24th, 2001
 * Code Cleanup and comment translation
 */
 
#include <stdio.h>
#include "portable.h"

#ifndef INIMAN_H
#define INIMAN_H

#ifdef __cplusplus
extern "C" {
#endif

  /* Types definition */
#ifndef INIMAN_C
  typedef void *PINIFILE;
#endif
  
  PINIFILE EDMAPROC edma_open_ini (EPChar);
  ESint32  EDMAPROC edma_close_ini (PINIFILE);
  ESint32  EDMAPROC edma_clean_ini_string (EPChar);
  ESint32  EDMAPROC edma_get_ini_int (PINIFILE, EPChar, EPChar, ESint32);
  EUint32  EDMAPROC edma_get_ini_string (PINIFILE, EPChar, EPChar, EPChar, EPChar, EUint32);

#ifdef __cplusplus
}
#endif

#endif
