/*
 * EDMA: Entorno de Desarrollo Modular y Abierto
 * Object Oriented and Componetware Framework
 * Copyright (C) 1998, 2002, 2003, 2004, 2005 David Martnez Oliveira
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.

 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/  

/*
 * Entorno de Desarrollo Modular y Abierto
 * Versin Beta 0.3r1
 * (c) David Martnez Oliveira
 *
 * Modulo para gestin Extensiones EMI (Extension Management Interface)
 * Revisiones: ---------------------------------------------------------
 * 2 de Octubre
 * Adimos funciones para la gestin EMI.
 * Inicialmente solo excepcin CLASS_NOT_FOUND
 *
 * Aadimos en este mdulo las funciones para actualizar el fichero
 * EDMA32.CFG
 * --------------------------------------------------------------------
 * 19 de Febrero de 2000
 * Hacemos que se modifique el registro real de clases, para poder 
 * utilizar las funciones de soporte de instalacin dinmica de clases.
 *-------------------------------------------------------------------
 * Revisions:
 * November, 18th, 2001
 * Fixed ActualizeCFG which didn't write the correct IDF parser
 * for classes using an IngrIDF parser
 * -------------------------------------------------------------
 * March, 2nd, 2002
 * Code cleanup
 * ------------------------------------------------------------
 * July, 13th, 2002
 * Now, we save version information in the GNU/EDMA registry
 * ---------------------------------------------------------------
 * May, 10th, 2003
 * Modification to support changes to internal class structures
 * ------------------------------------------------------------------
 * July, 3rd, 2003
 * Cosmetic changes, parameter sanity checks
 * --------------------------------------------------------
 * January, 6th, 2004
 * Modifications due to GNU/EDMA SubSystem Management API Unification
 */
 
#include <stdio.h>
#include "portable.h"
#include "subsystems.h"
#include "multiidf.h"
#include "vglobal.h"
#include "classq.h"
#include "misc.h"
#include "inh.h"

#include "subsystems.h"
#include "helper.h"

/* edma_get_EMI_handler
 *    Deprecated. Use edma_subsystem API
 */

ESint32 EDMAPROC 
edma_get_EMI_handler (EPChar handler_name) 
{
  return edma_subsystem_get_item (SS_EMI, handler_name);
}

/* edma_add_EMI_handler
 *   Register class 'ClassName' as an EMI handler for 'Name'
 *   DEPRECATED: Use edma_subsystem APO
 */

ESint32 EDMAPROC 
edma_add_EMI_handler (EPChar handler_name,EPChar class_name) 
{
  return edma_subsystem_add_item (SS_EMI, handler_name, class_name);
}

/* edma_hook_get_class
 *   Makes class 'IdClass' current handler for 'GetClass' 
 */
EUint32 EDMAPROC 
edma_hook_get_class (CLASSID IdClass) 
{
  if ((edma_check_class_id (IdClass, "edma_hook_get_class")) == -1)
    return -1;

  GVar->GetClassEMI=IdClass;
  return 0;
}

/* edma_get_EMI_num_handlers
 *   Returns the number of EMI handlers registered
 *   DEPRECATED: Use edma_system API
 */

ESint32 EDMAPROC 
edma_get_EMI_num_handlers (void) 
{
  return edma_subsystem_get_num_items (SS_EMI);
}


/* edma_get_EMI_handler_class
 *   Returns class if the i-th EMI handler registered
 *   DEPRECATED: Use edma_subsystem API
 */
CLASSID EDMAPROC 
edma_get_EMI_handler_class (ESint32 i) 
{
  return edma_subsystem_get_item_class (SS_EMI, i);
}

/* edma_actualize_cfg
 *   This function updates GNU/EDMA register with on-memory information
 */
ESint32 EDMAPROC 
edma_actualize_cfg () 
{
  FILE		*fich;
  EChar		Cadena[1024];
  EUint32	i,j,index;
  EPChar	Aux;
  
  strncpy (Cadena, GVar->SystemPath, 1024);
  /* FIXME: This should be precalculated and it depends on OS*/
  strncat (Cadena, "/etc/edma32.cfg", 1024);
  
  edma_printf ("[edma_actualize_cfg] Output File : %s", Cadena);
  /* FIXME: Here we should check if we can update GNU/EDMA register
   * Now, a warnning message will be showed on applications shutdown
   */

  fich = fopen (Cadena,"wt");
  if (fich == NULL) 
    {
      edma_printf_err("[edma_actualize_cfg] Cant open EDMA32.CFG for update");
      return -1;
    }

  fprintf (fich,"[General]\n");
  fprintf (fich,"nClasses=%ld\n", GVar->nClases);
  j = 0;

  /* Only dump shared classes */
  for (i = 0; j < GVar->nClases; i++) 
    {
      if (gClass[i] && (ProcMapTable[i] != CLASS_FREE)) 
	{
	  fprintf (fich, "[CLASS%ld]\n", j);
	  fprintf (fich, "ClassName=%s\n", gClass[i]->ClassName);
	  if (strlen (gClass[i]->NameSpace) > 0)
	    fprintf (fich, "NameSpace=%s\n", gClass[i]->NameSpace);
	  fprintf (fich, "Machine=%s\n", GVar->SysMaq[gClass[i]->MaqId].Nombre);
	  fprintf (fich, "OperatingSystem=%s\n", GVar->SysSO[gClass[i]->SOId].Nombre);
	  
	  Aux = gClass[i]->SysClass.ModuleName;
	  fprintf (fich, "Implementation=%s\n", Aux);
	  
	  if (gClass[i]->IDFParser == 0)
	    fprintf (fich, "IDFParser=EDMAIDF\n");
	  else 
	    {
	      index = gClass[i]->IDFParser;
	      fprintf (fich, "IDFParser=%s\n",
		       //gClass[GVar->IDFParser[index].IdClass]->ClassName);
		       gClass[edma_subsystem_get_item_class (SS_INGRIDF, index)]->ClassName);
	    }
	  if (gClass[i]->IsIDF)
	    fprintf (fich, "IsIDFParser=1\n");
	  if (gClass[i]->IsSIU)
	    fprintf (fich, "IsSIUProxy=1\n");
	  if (gClass[i]->IsEMI)
	    fprintf (fich, "IsEMI=1\n");
	  if (gClass[i]->SIUProxy != -1)
	    fprintf (fich, "SIUProxy=%s\n", gClass[gClass[i]->SIUProxy]->ClassName);
	  fprintf (fich, "MajorVer=%d\n", gClass[i]->MajorVer);
	  fprintf (fich, "MinorVer=%d\n", gClass[i]->MinorVer);
	  fprintf (fich, "CurrentVer=%ld\n", gClass[i]->CurrentVer);
	  j++;
	}
      
    }
  fprintf (fich, "[]");
  fclose (fich);
  /* TODO: Save local register if any*/
  edma_printf ("[edma_actualize_cfg] Exit");
  return 0;
}
