/*
    server_test Version 0.0
    Copyright (C) 1998-1999 David Martnez Oliveira
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.    

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; see the file COPYING.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <signal.h>
#include <time.h>
#include <unistd.h>

#include <pthread.h>

#include <edma.h>

ESint32 manage_request (OBJID IdObj,OBJID c);
void *run_request (void *par);

main(int argc,char *argv[])
{
  OBJID id;

  if (argc!=2) {
    printf ("Paramter number incorrect. Try:\n");
    printf ("\tserver_test SOCKET_TCP://localhost:port\n\n");
    return -1;
  }
  
  /* Initialize EDMA System */
  EDMAInit ();
  printf ("\nServer Skeleton Test");
  printf ("\n(c) David Martnez Oliviera, 2001");
  printf ("\n\n");
  printf ("\n+ Bringing up server on resource :\n");
  printf (  "  %s",argv[1]);

  /* Put your C code here */
  id = edma_new_obj ("SERVER_SKEL");
  if (id == -1) 
    {
      printf ("\n[ERROR] Can't create SERVER_SKEL object");
      EDMAEnd();
      return -1;
    }
  if (-1 == (ESint32) edma_met3 (id, "init", argv[1])) 
    {
      printf ("\n[ERROR] Can't init server");
      EDMAEnd();
      exit(-1);
    }
  edma_over_met (id, "onRequest", NULL, (PPROC) manage_request);
  if (-1 == (ESint32) edma_met3 (id, "run")) 
    {
      printf ("\n[ERROR] Waiting for requests");
      EDMAEnd();
      return -1;
    }
  edma_free_obj (id);

  /* Shutdown EDMA Suystem */
  EDMAEnd();
  return 0;
}

ESint32 manage_request (OBJID id,OBJID idc) {
  pthread_t  tid;
  static OBJID      my_id;

  my_id=idc;
  pthread_create (&tid,NULL,run_request,(void*)&my_id);
  printf ("[INFO] Thread %p running\n",tid);

  return 0;
}

void *run_request (void *par) {
  EChar    remote[1024];
  OBJID    idc;

  idc=*((OBJID *)par);
  printf ("\n[INFO] Using object %d",idc);

  edma_rprop3 (idc, "Resource",remote);
  printf ("\n[INFO] Request from : %s\n",remote);
  sleep (3);
  edma_met3 (idc,"close");
  edma_free_obj (idc);
  printf ("\n[INFO] Processing finished for %s\n",remote);
  return 0;
}



