/*
    server_test (Multithread version) Version 0.0
    Copyright (C) 1998-1999 David Martnez Oliveira
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.    

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; see the file COPYING.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
 */

/*
 * DESCRIPTION
 * Simple test of the MTSERVER_SKEL class which allow us to build multithreaded
 * server on an easy way.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <signal.h>
#include <time.h>
#include <unistd.h>

#include <edma.h>

ESint32 manage_request (OBJID IdObj,OBJID c);

int main(int argc,char *argv[])
{
  OBJID id;

  if (argc!=2) {
    printf ("Parameter number incorrect. Try:\n");
    printf ("\tserver_test SOCKET_TCP://localhost:port\n\n");
    return -1;
  }
  
  /* Initialize EDMA System */
  EDMAInit();
  /* Show Application banner */
  printf ("\nMultiThread Server Skeleton Test");
  printf ("\n10 clients limit");
  printf ("\n(c) David Martnez Oliviera, 2001");
  printf ("\n\n");
  printf ("\n+ Bringing up server on resource :\n");
  printf (  "  %s",argv[1]);
  /* application's banner finish here*/

  /* Put your C code here */
  if ((id = edma_new_obj ("MTSERVER_SKEL")) == -1)
    {
      fprintf (stderr, "Can't create object MTSERVER_SKEL\n");
      EDMAEnd ();
      exit (1);
    }
  
  /* Inits multithread server to manage upto 10 simultaneous clients*/
  if (-1 == (ESint32) edma_met3 (id, "init", argv[1], 10)) 
    {
      fprintf (stderr, "Can't init server...\n");
      EDMAEnd ();
      exit (1);
    }

  /* Sets the function to manage each request*/
  edma_over_met (id, "onRequest", NULL, (PPROC)manage_request);

  /* Lauch server's main loop */
  if (-1 == (ESint32) edma_met3 (id, "run")) 
    {
      fprintf (stderr, "Can't run server\n");
      EDMAEnd ();
      exit (1);
    }

  edma_free_obj (id);
  /* Shutdown EDMA Suystem */
  EDMAEnd();
  return 0;
}

/*
 * manage_request: This function manages each request that arrives to the server
 * in this simple example, it only shows the origin of the request and waits 3 secs
 * to allow us try the multithread capability of this server
 */  
ESint32 manage_request (OBJID id,OBJID idc) {
  EChar         remote[256];

  printf ("\n[INFO] Using object %d",idc);
  edma_rprop3 (idc, "Resource", remote);
  printf ("\n[INFO] Request from : %s\n",remote);
  sleep (3);
  edma_met3 (idc, "close");
  /*edma_free_obj (idc);*/
  printf ("\n[INFO] Processing finished for %s\n",remote);
  return 0;
}

