/*
    CHANNEL_TEST Name Version 0.0
    Copyright (C) 1998-1999 David Martnez Oliveira
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.    

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; see the file COPYING.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include <edma.h>

main(int argc,char *argv[])
{
  OBJID        id_channel;
  EDMAT_BUFFER sbuf,rbuf;
  ESint32      len;

  /* Initialize EDMA System*/
  EDMAInit();

  /* Put your C code here */
  EBufferAlloc (&sbuf,1024);
  EBufferAlloc (&rbuf,1024);
	
  strcpy ((EPChar)sbuf.dat,"Hello World!!!!");
  printf ("\n");
  if ((id_channel=NewObj("CHANNEL",NULL))==-1) {
					fprintf (stderr,"Can't create CHANNEL object\n");
					EDMAEnd();
					exit(1);
	}
  Met3(id_channel,"open",">SOCKET_TCP://localhost:10000");
  Met3(id_channel,"send",sbuf,50);
  Met3(id_channel,"recv",&rbuf,&len);

  printf ("%d bytes Received\n",len);
  printf ("Data Received:\n%s\n",rbuf.dat);
	
  Met3(id_channel,"close");
  FreeObj(id_channel);
  /* Shutdown EDMA Suystem */
  EDMAEnd();
  return 0;
}

