/*
    Example aplication for class STREAM
    Copyright (C) 1998-1999 David Martnez Oliveira
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.   
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    You should have received a copy of the GNU General Public License
    along with this program; see the file COPYING.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <time.h>
#include <unistd.h>

#include <edma.h>


main(int argc,char *argv[])
{
  OBJID         id;    /*This will be the EDMA NFILE Object*/
  EDMAT_BUFFER  data;  /*EDMA Type Buffer for reading file data*/
  ESint32       i;

  /* Initialize EDMA System */
  EDMAInit();

  /* Put your C code here */
  printf ("\n------------------------------------------------");
  printf ("\nSimple STREAM Example");
  printf ("\n(c) David Martnez Oliveira 2000");
  printf ("\n\n");
  printf ("* Creating STREAM Object (id=pNewObj(\"STREAM\",NULL);)\n");
  if ((id = edma_new_obj ("STREAM")) == -1) {
    edma_print ("Can't create STREAM object. Aborting ....");
    EDMAEnd();
    exit(1);
  }
  edma_obj_report (id);
  printf ("* Reading file. We will read out source code :)");
  printf ("\n  > pMet3 (id,\"Load\",\"(NFILE)./nfile_example.c\",&data);\n");
  printf ("\n");
  edma_met3 (id,"Load","(NFILE)./nfile_example.c",&data);
  printf ("\nPress any key for viewing file");
  getchar();
  printf ("\n---------------------------------------------");
  printf ("\n%s",data.dat);
  printf ("\n---------------------------------------------");
  printf ("\nTesting Save method");
  printf ("\n  > pMet3 (id,\"Save\",\"./test.stream\",data);\n");
  edma_met3 (id,"Save","(NFILE)./test.stream",data);
  printf ("\nFile nfile_example.c copied to test.out");
  printf ("\n------------------------------------------------");
  printf ("\nTesting overriden methods\n");
  edma_met3 (id,"Open","(NFILE)./nfile_example.c");
  i=300;
  memset (data.dat,0,data.Size);
  edma_met3 (id,"Read",data,&i);
  printf ("\n%d bytes read from file:\nPress any key to see data",i);
  getchar();
  printf ("\n---------------------------------------------");
  printf ("\n%s",data.dat);
  printf ("\n---------------------------------------------");
  memset (data.dat,0,data.Size);
  edma_met3 (id,"Read",data,&i);
  printf ("\n%d bytes read from file:\nPress any key to see data",i);
  getchar();

  printf ("\n---------------------------------------------");
  printf ("\n%s",data.dat);
  printf ("\n---------------------------------------------");
  printf ("\n");
  edma_obj_report (id);
  edma_met3 (id,"Close");
  edma_free_obj (id);
  edma_obj_report (id);
  
  /* Shutdown EDMA Suystem */
  EDMAEnd();
  return 0;
}
