/*
    Example aplication for class NFILE
    Copyright (C) 1998-2000 David Martnez Oliveira
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.   
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    You should have received a copy of the GNU General Public License
    along with this program; see the file COPYING.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <time.h>
#include <unistd.h>

#include <edma.h>


main(int argc,char *argv[])
{
  OBJID         id;    /*This will be the EDMA NFILE Object*/
  EDMAT_BUFFER  data;  /*EDMA Type Buffer for reading file data*/

  /* Initialize EDMA System */
  EDMAInit();

  /* Put your C code here */
  printf ("\n------------------------------------------------");
  printf ("\nSimple NFILE Example");
  printf ("\n(c) David Martnez Oliveira 2000");
  printf ("\n\n");
  printf ("\nTesting Load method");
  printf ("* Creating NFILE Object (id=pNewObj(\"NFILE\",NULL");
	
  if ((id=edma_new_obj ("NFILE")) == -1) {
    edma_print ("Can't create NFILE object. Aborting...");
    EDMAEnd();
    exit(1);
  }
  printf ("* Reading file. We will read out source code :)");
  printf ("  > pMet3 (id,\"Load\",\"./nfile_example.c\",&data);");
  edma_met3 (id,"Load","./nfile_example.c",&data);
  printf ("\nPress any key for viewing data read");
  getchar();
  printf ("\n---------------------------------------------");
  printf ("\n%s",data.dat);
  printf ("\n---------------------------------------------");
  printf ("\nTesting Save method");
  printf ("  > pMet3 (id,\"Save\",\"./test.nfile\",data);");
  edma_met3 (id,"Save","./test.nfile",data);
  printf ("\nFile nfile_example.c copied to test.out");
  edma_free_obj (id);
  /* Shutdown EDMA Suystem */
  EDMAEnd();
  return 0;
}

