/*
    Simple ID Class Demo
    Copyright (C) 1998-1999 David Martnez Oliveira

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; see the file COPYING.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.

 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <time.h>
#include <unistd.h>

#include <edma.h>

main(int argc,char *argv[])
{
  OBJID         id;
  ESint32       i,n;
  EPChar        p;
  EChar         cn[80],sid[80],des[80];
 
  /* Initialize EDMA System */
  EDMAInit();
  
  if ((id=edma_new_obj ("ID"))==-1) {
    edma_print ("Can't create ID object");
    EDMAEnd();
    exit(1);
  }
  edma_met3 (id,"SetDB","./builders.db");
  edma_rprop3 (id,"nElems",&n);
  for (i=0;i<n;i++)
    {
      edma_met3 (id,"GetItem",i,cn,sid,des);
      printf ("\nItem %02d -> %s (*.%s): %s",i,cn,sid,des);
    }
  edma_free_obj (id);
  EDMAEnd();
  return 0;
}











