/*
    Hello World EDMA Application Example Version V 0.0
    Copyright (C) 1998-2000 David Martnez Oliveira
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    You should have received a copy of the GNU General Public License
    along with this program; see the file COPYING.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <signal.h>
#include <time.h>
#include <unistd.h>

#include <edma.h>

EUint32 crash=0;

void HandleEx (int s);

main(int argc,char *argv[])
{
  OBJID    id_hw;
  ESint32  num;
  EChar    str[80];

  /* Initialize signal handler */
  signal (SIGSEGV,HandleEx);
  signal (SIGTERM,HandleEx);
  signal (SIGQUIT,HandleEx);
  signal (SIGINT,HandleEx);
  /* Initialize EDMA System */
	EDMAInit();

	/* Put your C code here */
  printf ("\n-----------------------------------------------------------\n");
  if ((id_hw=pNewObj("HELLO_WORLD_CPP",NULL))==-1) {
					ECout1 ("Can't create HELLO_WORLD_CPP object. Aborting...");
					EDMAEnd();
					exit(1);
	}
  
  Met3(id_hw,"say");
 
  WProp3(id_hw,"num",256);
  WProp3(id_hw,"str","Hello again!!!");

  Met3(id_hw,"say");
  Met3(id_hw,"say2","Parameter test");

  RProp3(id_hw,"num",&num);
  RProp3(id_hw,"str",&str);

  printf ("\n>>>>Properties: [%d] [%s]\n\n",num,str);
  
  FreeObj(id_hw);
  printf ("\n-----------------------------------------------------------");
/* Shutdown EDMA Suystem */
  EDMAEnd();
  return 0;
}

/*Signal Handler for on exception shutdown*/
void HandleEx (int s)
{
   if (crash)
     {
        printf ("\nException received while shutdown");
        exit(1);
     }
   else
     {
        crash=1;
        printf ("\n Signal recived: %d",s);
        printf ("\n %s",strsignal(s));
        printf ("\n EDMA abrupt shutdown required");
        pEDMAEnd();
        exit (1);
     }
}
