/*
    PROCEXEC Basic Class. Beta Version
    Copyright (C) 1998-2005 David Martnez Oliveira

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; see the file COPYING.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

/**************************************************
    Entorno de Desarrollo Modular y Abierto
    EDMA 0.2r1
    (c) David Martnez Oliveira
    File generated by : EDMA IDF WIzard Tcl/Tk 0.1
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : PROCEXEC
    Description : Process Execution 
    Author      : David Martnez Oliveira
    Date        : 3/11/1998
-----------------------------------------------------
  REVISIONS :
  3/11/1998: File creation
  * -----------------------------------------------------
  * November, 7th, 2004
  * Code clean up and minor interface changes 
  ***************************************************/
 
 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <signal.h>
#include "edma.h"

#define NOT_RUNNING 0
#define RUNNING 1
#define PIPED_PROCESS 2
#define PIPED_PROCESS2 3
 
typedef struct
  {
    EUint32	Status;
    EUint32	pid;
    EUint32     fdR;      /* used as int and FILE*. Supposing sizeof(void*)=sizeof(long)*/
    EUint32     fdW;

  } DtPROCEXEC;
 
/* Method Implementation for class PROC_EXEC */
 
 
EUint32  EDMAPROC 
PROCEXECRunZ (OBJID IdObj,EPChar cmd1)
{
  DtPROCEXEC	*m;
  EChar         *argv[20]; /* Up to 20 parameters */
  EChar         cmd[256];
  EUint32       i, n;
  EPChar        p, p1;

  m = (DtPROCEXEC*) edma_get_data_ref (IdObj);
 
  strncpy (cmd, cmd1, 256);
  /* We build argv array */
  edma_printf_obj (IdObj, "%s", "Building exec parameter array...");

  n = 0;
  for (i = 0; i < strlen(cmd); i++)
    if (cmd[i] == ' ') n++;

  edma_printf_obj (IdObj, "  %d parameters located...", n+1);
  p = cmd;
  for (i = 0; i < n; i++) 
    {
      p1 = strchr (p, ' ');
      *p1 = 0;
      edma_printf_obj (IdObj, "Parameter isolated : %s", p);
      argv[i] = p;
      p = p1 + 1;
    }
  argv[n] = p;
  argv[n + 1] = 0;

  edma_printf_obj (IdObj, "Parameter Isolated : %s", p);
  edma_printf_obj (IdObj, "%s", "Parameters added to parameter array...");

  /* We create a child process */
  m->pid = fork();
  if (m->pid == 0)  
    { /* if in child process */
      /* Ready for execution */
      if (execvp (argv[0], (char **)argv) < 0) 
	{
	  edma_printf_obj (IdObj,  "Could not exec %s\n", argv[0]);
	}
      exit (0);   /* kill child process */
    }

  m->Status = RUNNING;

  return 0;
}
 
EUint32  EDMAPROC 
PROCEXECRunPipedZ(OBJID IdObj, EPChar cmd1)
{
  DtPROCEXEC	*m;
  EChar         *argv[20]; /* Up to 20 parameters */
  EChar         cmd[256];
  EUint32       i, n;
  EPChar        p, p1;
  int           fd[2];

  m = (DtPROCEXEC*) edma_get_data_ref (IdObj);
 
  strncpy (cmd, cmd1, 256);
  /* We build argv array */
  edma_printf_obj (IdObj, "%s", "Building exec parameter array...");

  n = 0;
  for (i = 0; i < strlen(cmd); i++)
    if (cmd[i] == ' ') n++;

  edma_printf_obj (IdObj, "  %d parameters located...", n + 1);
  p = cmd;
  for (i = 0; i < n; i++) 
    {
      p1 = strchr (p, ' ');
      *p1 = 0;
      edma_printf_obj (IdObj, "Parameter isolated : %s", p);
      argv[i] = p;
      p = p1 + 1;
  }
  argv[n] = p;
  argv[n+1] = 0;
  edma_printf_obj (IdObj, "Parameter Isolated : %s", p);
  edma_printf_obj (IdObj, "%s", "Parameters added to parameter array...");
  /* Now, we create the pipe */

  if (pipe(fd) < 0) 
    {
      edma_printf_obj (IdObj, "%s", "Can't create pipe\n");
      return 0;
    }

  m->fdR = fd[0];
  m->fdW = fd[1];
  /*  setvbuf(stdout,NULL,_IOLBF,0); */
  /* We create a child process */
  m->pid = fork();
  if (m->pid == 0)  
    { /* if in child process */
      /* Initiating pipe
	 Duplicating standard output file descritor */
      dup2 (fd[1], STDOUT_FILENO);
      /* Closing fd[1]; */
      close (fd[1]);
      /* we make files unbuffered
	 setlinebuf(fd[0]);
	 setlinebuf(fd[1]); */
      /* Ready for execution */
      if (execvp (argv[0], (char**)argv) < 0) 
	{
	  edma_printf_obj (IdObj, "Could not exec %s\n", argv[0]);
	}
      exit (0);   /* kill child process */
    }
  m->Status = PIPED_PROCESS;

  return 0;
}
 
EUint32  EDMAPROC 
PROCEXECWait(OBJID IdObj)
{
  DtPROCEXEC	*m;
  pid_t         p;
  
  m=(DtPROCEXEC*)edma_get_data_ref(IdObj);
  
  wait (&p); 
  return p;
}
 
EUint32  EDMAPROC 
PROCEXECGetMsgsZsS32(OBJID IdObj,EPChar msg,EUint32 *n)
{
  DtPROCEXEC	  *m;
  ESint32         r;
  
  m = (DtPROCEXEC*) edma_get_data_ref (IdObj);
  
  edma_printf_obj (IdObj, "%s", "Ready for Retrieve data"); 
  if (m->Status == PIPED_PROCESS) 
    r = read (m->fdR, msg, *n); 
  edma_printf_obj (IdObj, "%s", "Data retrieved from pipe");

  *n = r;
  
  return 0;
}
 
EUint32  EDMAPROC PROCEXECKill(OBJID IdObj)
{
  DtPROCEXEC	*m;
  pid_t         s;
  
  m = (DtPROCEXEC*) edma_get_data_ref (IdObj);
 
  kill (m->pid, 9); 
  waitpid (m->pid, &s, 0);

  return 0;
}

/*
** New Functions for Type II piped processes (popen)
** 15/01/1998
**
*/
 
EUint32  EDMAPROC 
PROCEXECRunPiped2Z(OBJID IdObj,EPChar cmd1)
{
  DtPROCEXEC	*m;

  m = (DtPROCEXEC*) edma_get_data_ref (IdObj);
 
  edma_printf_obj (IdObj, "Running PIPED Process Type II : '%s'", cmd1);
  if ((m->fdR = (EUint32) popen (cmd1, "r")) < 0)
    {
      edma_printf_obj (IdObj, "popen Fails... Cannot execute command '%s'", cmd1);
      return -1;
    }

  edma_printf_obj (IdObj, " -- Stream located : %d", m->fdR);
  m->Status = PIPED_PROCESS2;

  return 0;
}
 
 
EUint32  EDMAPROC 
PROCEXECGetMsg2sZsS32(OBJID IdObj, EPChar msg, EUint32 *n)
{
  DtPROCEXEC	  *m;
  EChar           *r;
 
  m = (DtPROCEXEC*) edma_get_data_ref (IdObj);
 
  if (m->Status == PIPED_PROCESS2) 
    r = fgets (msg, *n, (FILE*) m->fdR); 

  if (r == NULL)
    *n = 0;
  else 
    *n = strlen(msg);
  
  return 0;
}







