/*
  EDMA Advanced Class PERL_INTERPRETER
  Copyright (C) 1998-2005 David Martnez Oliveira

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; see the file COPYING.  If not, write to
  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
*/

/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.5.1r1
    (c) David Martnez Oliveira
    File generated by : EDMA IDF Wizard Gnomized 0.1
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : PERL_INTERPRETER
    Description : Allows ti build and execute simple Perl scripts
    Author      : David Martnez Oliveira
    Date        : 27/02/2000
-----------------------------------------------------
  REVISIONS :
  May, 18th, 2002
  Updated to work with GNU/EDMA 0.9.3
***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
 
#include <stdio.h>
#include <string.h>

/*
***************************************************
  EDMA Header Files
***************************************************
*/
 
#include <edma.h>
/*
******************************************************
  Perl specific includes
  ****************************************************
 */

#include <EXTERN.h>               /* from the Perl distribution     */
#include <perl.h>                 /* from the Perl distribution     */

/*
***************************************************
  Private Data Struct for class PERL_INTERPRETER
***************************************************
*/
 
typedef struct  {
    PerlInterpreter   *my_perl;
}DtPERL_INTERPRETER;

/*
***************************************************
  Method Declaration for class pi
***************************************************
*/

#ifdef __cplusplus
#  define EXTERN_C extern "C"
#else
#  define EXTERN_C extern
#endif

EXTERN_C void boot_DynaLoader (pTHX_ CV* cv);

EXTERN_C void
xs_init(pTHX)
{
  char *file = __FILE__;

  /* DynaLoader is a special case */
  printf ("%s", "About to load dynamic loader...\n");
  newXS ("DynaLoader::boot_DynaLoader", boot_DynaLoader, file);
  printf ("%s", "DynaLoader... loaded\n");
}


ESint32 EDMAPROC 
PERL_INTERPRETERborn(OBJID IdObj)
{
  DtPERL_INTERPRETER	*m;
  int                   argc = 1;
  char                  *argv[] = {"pia", NULL};

  m = (DtPERL_INTERPRETER*) edma_get_data_ref (IdObj);
  m->my_perl = perl_alloc ();
  perl_construct (m->my_perl);
  edma_printf_obj (IdObj, "%s", "Parsing perl...");

 return 0;
}

ESint32 EDMAPROC 
PERL_INTERPRETERrip(OBJID IdObj)
{
DtPERL_INTERPRETER	*m;

 m = (DtPERL_INTERPRETER*) edma_get_data_ref (IdObj);
 
 perl_destruct (m->my_perl);
 perl_free (m->my_perl);
 
 return 0;
}


ESint32 EDMAPROC 
PERL_INTERPRETERAddLineZ(OBJID IdObj)
{
  DtPERL_INTERPRETER	*m;

  m = (DtPERL_INTERPRETER*) edma_get_data_ref (IdObj);
}


ESint32 EDMAPROC 
PERL_INTERPRETERRun(OBJID IdObj,EPChar cmd)
{
  DtPERL_INTERPRETER	*m;
  char *embedding[] = { "", "-e", cmd, "0"};
  
  m = (DtPERL_INTERPRETER*) edma_get_data_ref (IdObj);
  
  perl_parse (m->my_perl, xs_init, 4, embedding, (char **)NULL);
  perl_run (m->my_perl);
  
  return 0;
}
/********** END C IMPLEMENTATION SKELETON ******************/
