
/*
  EDMA Advanced Class MONO_JIT
  Copyright (C) 1998-2000 David Martnez Oliveira

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; see the file COPYING.  If not, write to
  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
*/

/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.9.4
    (c) David Martnez Oliveira
    File generated by : EDMA C Implementation Builder class
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : MONO_JIT
    Description : Class to init MONO JIT compiler
    Author      : David Martnez Oliveira
    Date        : September, 10th, 2002
    Version     : 0.0
-----------------------------------------------------
  REVISIONS :
  TODO:
  * Set GNU/EDMA primitives in the MONO domain throiugh P/Invoke functions
***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
 
/* Add here the includes you need for your class*/

/*
***************************************************
  EDMA Header Files
***************************************************
*/
 
#include <edma.h>

#include <mono/jit/jit.h>

static MonoDomain  *mono_domain = NULL;
/*
***************************************************
  Private Data Struct for class MONO_JIT
***************************************************
*/
 
/*
typedef struct {
 Put your field here
} DtMONO_JIT;
*/

/*
***************************************************
  Method Declaration for class MONO_JIT
***************************************************
*/
 

static int 
monna_new_obj (MonoString *class_name)
{
  OBJID id;

  edma_printf ("Creating object from MONO: %s",
	       mono_string_to_utf8(class_name));   
  id = edma_new_obj (mono_string_to_utf8(class_name));
  return id;
}

static int
monna_free_obj (int id)
{
  edma_printf ("Destroying object %d", id);
  edma_free_obj (id);
  return 0;
}

static int
monna_met3 (int id, MonoString *met_name, MonoArray *p)
{
  int   i,n;
  MonoObject *o;
  MonoObject **oo;
  unsigned char *p1;
  long long a;

  edma_printf ("Running method  %s on object %d.", 
	       mono_string_to_utf8(met_name), id);
  edma_printf ("Receiving %d parameters", p->max_length);
  n = p->max_length;
  p1 = p->vector;
  for (i = 0; i < n; i++)
    {
      
      //o = *(MonoObject**)(p1 + i * sizeof(MonoObject));
      
      o = *(MonoObject**)mono_array_get(p,MonoObject**,i);
      p1 = (unsigned char *)(p->vector) + i *sizeof(p->vector);
      oo = &p->vector[i];
      o = *oo;
      edma_printf ("Parameter %d: %p %p", i, p->vector[i], o);
      //edma_printf ("Value : %x", *(int*)o->vtable->data);

    }
  edma_met3 (id, mono_string_to_utf8(met_name));
  return 0;
}

ESint32 EDMAPROC
MONO_JITborn(OBJID IdObj)
{
  if (!mono_domain)
    {
      mono_domain = mono_jit_init ("edma-monna");
      /* Add internal calls */
      mono_add_internal_call ("GnuEDMA::new_obj", monna_new_obj);
      mono_add_internal_call ("GnuEDMA::free_obj", monna_free_obj);
      mono_add_internal_call ("GnuEDMA::met3", monna_met3);
      if (!mono_domain)
	{
	  edma_printf_obj (IdObj, "Can't init MONO_JIT");
	  return -1;
	}
    }
  return 0;
}


ESint32 EDMAPROC
MONO_JITrip(OBJID IdObj)
{
  mono_jit_cleanup (mono_domain);
  return 0;
}


ESint32 EDMAPROC
MONO_JITrunZrS32(OBJID IdObj, EPChar fname)
{
  MonoAssembly    *assembly;
  ESint32         retval;
  /* Single implementation without parameters*/

  assembly = mono_domain_assembly_open (mono_domain, fname);
  if (!assembly)
    {
      edma_printf_obj (IdObj, "Error loading assembly\n");
      return -1;
    }
  
  /* Next line runs the Main methdo... the same that executing the program*/
  retval = mono_jit_exec (mono_domain, assembly, 0, NULL);

  return retval;
}


ESint32 EDMAPROC
MONO_JITcreate_domainZ(OBJID IdObj)
{
  edma_printf_obj (IdObj, "Method 'create_domain' Not implemented");
  return 0;
}


/* Static Method get_domain*/

//ESint32 EDMAPROC
MonoDomain* EDMAPROC
MONO_JITget_domainrS32(CLASSID id)
{
  return mono_domain;
}


/********** END C IMPLEMENTATION SKELETON ******************/
