
/*
  EDMA Advanced Class MONNA_PROXY
  Copyright (C) 1998-2000 David Martnez Oliveira

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; see the file COPYING.  If not, write to
  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
*/

/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.9.4
    (c) David Martnez Oliveira
    File generated by : EDMA C Implementation Builder class
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : MONNA_PROXY
    Description : SIU Proxy for MONO classes
    Author      : David Martnez Oliveira
    Date        : September, 11th, 2002
    Version     : 0.0
-----------------------------------------------------
  REVISIONS :
  TODO:
  * manage of output and ref parameters on function calls
  * manage of arrays
  * read/write properties
***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
 
/* Add here the includes you need for your class*/

/*
***************************************************
  EDMA Header Files
***************************************************
*/
#include <string.h>
#include <stdarg.h>
#include <edma.h>

#include <mono/jit/jit.h>
#include <mono/metadata/debug-helpers.h>
/*
***************************************************
  Private Data Struct for class MONNA_PROXY
***************************************************
*/
 
typedef struct
{
  /*
	EUint32		mono_class;
	EUint32		mono_obj;
	EUint32		mono_domain;
	EUint32		mono_image;
  */
	MonoClass	*mono_class;
	MonoObject	*mono_obj;
	MonoDomain	*mono_domain;
	MonoImage	*mono_image;
	EPChar		mono_image_file;
}DtMONNA_PROXY;
/*
***************************************************
  Method Declaration for class MONNA_PROXY
***************************************************
*/
 
ESint32 EDMAPROC
MONNA_PROXYWProp3(OBJID IdObj, CLASSID cid, EPChar prop_name,EPVoid par)
{
DtMONNA_PROXY	*m;

m = (DtMONNA_PROXY *) edma_get_data_ref (IdObj);
}


ESint32 EDMAPROC
MONNA_PROXYRProp3(OBJID IdObj, CLASSID cid, EPChar prop_name,EPVoid par)
{
DtMONNA_PROXY	*m;

m = (DtMONNA_PROXY *) edma_get_data_ref (IdObj);
}


ESint32 EDMAPROC
MONNA_PROXYMet3(OBJID IdObj, CLASSID cid, EPChar met_name,EPVoid par1)
{
  DtMONNA_PROXY	  *m;
  MonoMethodDesc  *met_desc;
  MonoMethod      *the_met;
  EChar           desc[256];
  EChar           sig[256];
  EUint32         new_pars[20]; /* Upto 20 parameters*/
  EUint32         local[20];
  ESint32         i, j, n, output;
  EPUint32        par;

  m = (DtMONNA_PROXY *) edma_get_data_ref (IdObj);

  par = par1;
  /* Locate the method */
  /* First build a method description*/

  sprintf (desc, "%s:%s", m->mono_image_file, met_name);
  met_desc = mono_method_desc_new (desc, 1);
  the_met = mono_method_desc_search_in_image (met_desc, m->mono_image);
  if (!the_met)
    {
      fprintf (stderr, "Method not found\n");
      exit (1);
    } 
  strcpy (sig, (char*)*((EPUint32)par));
  ((EPUint32)par)++;
  /* Process signature */
  i = j = 0;
  n = strlen (sig);
  output = 0;
  while (i < n)
    {
      if (sig[i] == 's')
	output = 1;
      switch (sig[i])
	{
	case 'O':
	case 'U':
	case 'S':
	  if (output)
	    {
	      edma_printf ("Parameter %d is an output parameter", j);
	      //local[j] = *(EPUint32*)par[j];
	      local[j] = par[j];
	      new_pars[j] = local[j];
	      output = 0;
	    }
	  else
	    {
	      local[j] = par[j];

	      new_pars[j] = &local[j];
	    }
	  i++;
	  j++;
	  break;
	case 'Z':
	  new_pars[j] = mono_string_new (m->mono_domain, (char *) par[i]);
	  i++;
	  j++;
	  break;
	default:
	  i++;
	}
    }
  //mono_runtime_invoke (the_met, m->mono_obj, par, NULL);
  mono_runtime_invoke (the_met, m->mono_obj, new_pars, NULL);

  return 0;
}


ESint32 EDMAPROC
MONNA_PROXYNewObj(OBJID IdObj, EPChar name)
{
  DtMONNA_PROXY	*m;
  EPChar        class_name;
  EPChar        the_name;
  MonoAssembly    *assembly;

  m = (DtMONNA_PROXY *) edma_get_data_ref (IdObj);

  /* Get a MonoDomain from MONO_JIT singleton*/
  m->mono_domain = edma_smet3 ("MONO_JIT", "get_domain");

  the_name = strdup (name);
  class_name = strchr (the_name, '|');
  if (!class_name)
    {
      edma_printf_obj (IdObj, "Can't parse assembly:clase_anem");
      return -1;
    }

  *class_name = 0;
  class_name++;
  assembly = mono_domain_assembly_open (m->mono_domain, the_name);
  if (!assembly)
    {
      edma_printf_obj (IdObj, "Error loading assembly\n");
      return -1;
    }
  m->mono_image_file = strdup (class_name);

  m->mono_image = mono_image_loaded (the_name);
  if (!m->mono_image)
    {
      edma_printf_obj (IdObj, "Can't load image\n");
      exit (1);
    }

  m->mono_class = mono_class_from_name (m->mono_image, "", class_name);
  if (!m->mono_class)
    {
      edma_printf_obj (IdObj, "Can't locate class 'hola'\n");
      exit (1);
    }

  m->mono_obj = mono_object_new (m->mono_domain, m->mono_class);
  if (!m->mono_obj)
    {
      edma_printf_obj (IdObj, "Can't create object\n");
      exit (1);
    }
  /* Init object*/
  mono_runtime_class_init (m->mono_class);
  mono_runtime_object_init (m->mono_obj);

  /* We are done*/
  return 0;
}


ESint32 EDMAPROC
MONNA_PROXYFreeObj(OBJID IdObj)
{
  DtMONNA_PROXY	*m;

  m = (DtMONNA_PROXY *) edma_get_data_ref (IdObj);

  return 0;
}



/********** END C IMPLEMENTATION SKELETON ******************/
