/*
  fconfig Version 0.0
  Copyright (C) 1998,2002 David Martnez Oliveira
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; see the file COPYING.  If not, write to
  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
    
*/


#include <stdio.h>
#include <string.h>
#include <stdlib.h>

typedef struct config_file_t 
{
  char         *data;       /* Data buffer */
  long         len;
  char         sep;         /* Field separator*/
  int          multi;       /* Aceppts multival fields?*/
  
} FCONFIG,*PFCONFIG;

#define FCONFIG_C
#include "fconfig.h"

PFCONFIG 
fconfig_new (char *name, char sep, int multi) 
{
  PFCONFIG    p;
  int         len, i;
  FILE        *f;

  if ((p = (PFCONFIG) malloc (sizeof(FCONFIG))) == NULL) 
    {
      fprintf (stderr, "%s", "[ERROR] Can't alloc memory for configfile\n");
      return NULL;
    }

  if ((f = fopen (name, "rt")) == NULL) 
    {
      fprintf (stderr, "[ERROR] Can't open config file %s\n", name);
      free (p);
      return NULL;
    }
  /* Get file size and allocate memory to read the whole thing*/
  fseek (f, 0L, SEEK_END);
  p->len = len = ftell (f);
  fseek (f, 0L, SEEK_SET);
  if ((p->data = (char *) malloc (len)) == NULL) 
    {
      fprintf (stderr, "%s", "[ERROR] Can't allocate buffer for config file\n");
      free (p);
      fclose (f);
      return NULL;
    }
  
  if ((i = fread (p->data, len, 1, f)) == 0) 
    {
      fprintf (stderr, "[ERROR] Can't read data from %s\n", name);
      free (p->data);
      free (p);
      fclose (f);
      return NULL;
    }
  p->sep = sep;
  p->multi = multi;
  fclose (f);
  
  return (PFCONFIG) p;
}

int 
fconfig_free (PFCONFIG p) 
{
  free (p->data);
  free (p);
  
  return 0;
}

char *
fconfig_get_string (PFCONFIG p, char *key, char *res) 
{
  char        *aux,*aux1,*aux2;
  char        flag;
  char        temp[80];
  static char ires[80];  /* XXX: threads*/

  /* Look for target*/
  aux2 = p->data;
  memset (temp, 0, 80);
  flag = 1;
  while (flag) 
    {
      if ((aux = strstr (aux2, key)) == NULL) 
	{
#ifdef DEBUG
	  fprintf (stderr,"[ERROR] Can't find %s key\n",key);
#endif
	  return NULL;
	}
      
      /* Look back for comment*/
      flag = 0;
      for (aux1 = aux; ((aux1 > p->data) && (*aux1 != '\n')); aux1--)
	if (*aux1 == '#') 
	  {
	    aux2 = aux + strlen (key);
	    flag = 1;
	  }
      
    }
  if ((aux1 = strchr (aux, '\n')) == NULL) 
    {
#ifdef DEBUG
      fprintf (stderr, "[ERROR] Can't find %s key\n", key);
#endif
      return NULL;
    }
  strncpy (temp, aux, (aux1 - aux));
  temp[strlen (temp)] = 0;
  if ((aux = strchr (temp, '=')) == NULL) 
    {
#ifdef DEBUG
      fprintf (stderr, "%s", "[ERROR] Syntax Error. No value found!\n");
#endif
      return NULL;
    }
  /* Move forward upto data*/
  aux++;
  while (((*aux == ' ') || (*aux == '\t')) && (aux - temp < strlen (temp))) aux++;
  strcpy (ires, aux);
  if (res != NULL)
    strcpy (res, aux);
  
  return ires;
}

int 
fconfig_get_int (PFCONFIG obj,char *key, int *res) 
{
  char     r[50];
  
  fconfig_get_string (obj, key, r);
  *res = atoi(r);

  return 0;
}

int 
fconfig_get_long (PFCONFIG obj, char *key, long *res) 
{
  char     r[50];

  fconfig_get_string (obj, key, r);
  *res = atoi (r);

  return 0;
}

