/*
  EDMA Advanced Class EDMA_SIMPLEIDF
  Copyright (C) 1998-2005 David Martnez Oliveira

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; see the file COPYING.  If not, write to
  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
*/

#include <stdio.h>
#include <string.h>
#include <edma.h>

#include <fconfig.h>

ESint32 EDMAPROC 
EDMA_SIMPLEIDFParseU32 (OBJID id, CLASSID idc) 
{
  EChar     fn[2048];
  EChar     path[1024];
  EChar     aux[50];
  EChar     name[50], type[50], sig[50], access[50];
  ESint32   m_virtual, m_static, m_abstract;
  ESint32   i, n_elems, nProp, nMet;
  PFCONFIG  cfg;

  /* Get IDF directory*/
  edma_get_system_path (path);
  edma_get_class_name (idc,aux);
  sprintf (fn, "%s/share/edma/idf/%s.sidf", path, aux);

  edma_printf_obj (id, "Using IDF file : %s", fn);
  /* Open file to parse*/
  if ((cfg = fconfig_new (fn, ',', 1)) == NULL) 
    {
      edma_printf_err ("Can't open configuration file: %s",fn);
      return 1;
    }
  
  /* Get General information. Porperty, Method and Superclass Number*/
  fconfig_get_long (cfg, "Properties", &nProp);
  fconfig_get_long (cfg, "Methods", &nMet);

  edma_idf_set_def (idc, nProp, nMet, 0);

  /* Set properties*/
  for (i = 0; i < nProp; i++) 
    {
      memset (name, 0, 50);
      memset (type, 0, 50);
      memset (sig, 0, 50);
      memset (access, 0, 50);
      sprintf (aux, "Prop.%ld.Name", i);

      fconfig_get_string (cfg, aux, name);
      sprintf (aux, "Prop.%ld.Type",i);

      fconfig_get_string (cfg, aux, type);
      sprintf (aux, "Prop.%ld.Access", i);

      fconfig_get_string (cfg,aux,access);
      sprintf (aux,"Prop.%ld.ArrayElems",i);
      fconfig_get_long (cfg,aux,&n_elems);
      edma_printf_obj  (id, "%s %s %s %d", name, type,access, n_elems);
      edma_idf_set_prop (idc, i, name, type, access, n_elems, NULL);
    }
  /* Set Methods */
  for (i = 0;i < nMet; i++) 
    {
      memset (name, 0, 50);
      memset (type, 0, 50);
      memset (sig, 0, 50);
      
      sprintf (aux, "Met.%ld.Name", i);
      fconfig_get_string (cfg, aux, name);
      
      sprintf (aux, "Met.%ld.Signature", i);
      fconfig_get_string (cfg, aux, sig);
      
      sprintf (aux, "Met.%ld.Virtual", i);
      fconfig_get_long (cfg, aux, &m_virtual);
      
      sprintf (aux, "Met.%ld.Abstract", i);
      fconfig_get_long (cfg, aux, &m_abstract);
      
      sprintf (aux, "Met.%ld.Static", i);
      fconfig_get_long (cfg, aux, &m_static);
      
      edma_idf_set_met (idc, i, name, sig
			, m_virtual, m_abstract,m_static); 
    }
  /* Set Superclasses*/
  /*
  if ((fconfig_get_string (cfg,"Superclasses",aux))!=-1)
    IDFSetSCList(idc,aux);
  */
  edma_idf_set_class_id (idc);

  return 0;
}
