/*
  EDMA Advanced Class SOCKET_UDP
  Copyright (C) 1998-2005 David Martnez Oliveira

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; see the file COPYING.  If not, write to
  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
*/

/**************************************************
    Entorno de Desarrollo Modular y Abierto
    EDMA 0.5r1
    (c) David Martnez Oliveira
    File generated by : EDMA IDF WIzard Tcl/Tk 0.1
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : SOCKET_UDP
    Description : Datagram Socket Implementation
    Author      : David Martnez Oliveira
    Date        : 10 de Abril de 1999
-----------------------------------------------------
  REVISIONS :
  8/4/2001
  Added CHANNEL interface implementation for using SOCKET_UDP as
  communication class
***************************************************/
 
 
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>
/* Linux expecific includes */

#ifdef LINUX
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#endif

#include <edma.h>
/* Data structs for class SSOCK */
 
 
typedef struct
  {
    EUint32     s; 
    EPChar      resource;
    EUint32     LocalPort;
    EUint32     LocalAddr;
    EUint32     RemoteAddr;
    EUint32     RemotePort;
  } DtSSOCK;
 
/* Method Implementation for class $gnc */
 
 
EUint32  EDMAPROC 
SOCKET_UDPbindZU32 (OBJID IdObj, EPChar Name, EUint32 port)
{
  DtSSOCK    	      *m;
  struct sockaddr_in  local;
  struct hostent      *maq;
  EUint32             n;
  EChar               res[1024];
  
  m = (DtSSOCK *) edma_get_data_ref (IdObj);

  sprintf (res, "%s:%ld", Name, port);
  edma_wprop3 (IdObj, "resource", res);

  local.sin_family = AF_INET;
  local.sin_port = htons (port);
  
  if (Name == NULL)
    local.sin_addr.s_addr = htons (INADDR_ANY);
  else  
    /* Comprobamos si es hay que realizar resolucin de nombres */
    if (isdigit (Name[0]) ) /* Si el primer caracter es un nmero -> direccion IP */
      local.sin_addr.s_addr = inet_addr (Name); 
    else
      {
	maq = gethostbyname (Name);
	if (maq == NULL)
	  {
	    edma_printf_obj (IdObj, "(bind)Can't locate host %s", Name);
	    return 1;
	  }
	else
	  {
	    local.sin_addr = (*(struct in_addr *) (maq->h_addr));
	  }
      }   
  /* Socket binding */
  bzero (&(local.sin_zero), 8); 
  
  n = bind (m->s, (struct sockaddr *)&local, sizeof (struct sockaddr_in));
  if (n == -1)
    edma_printf_obj (IdObj, "(bind) Error");

  return n;
}
 
EUint32 EDMAPROC 
SOCKET_UDPsendAU32 (OBJID IdObj, EDMAT_BUFFER Buff, EUint32 len)
{
   DtSSOCK	*m;
   struct sockaddr_in    remote;
   EUint32       i;
 
   m = (DtSSOCK *) edma_get_data_ref (IdObj);

   /* Put your code here */

   remote.sin_family = AF_INET;
   remote.sin_port = m->RemotePort;
   remote.sin_addr.s_addr = m->RemoteAddr;
   
   i = sendto (m->s, Buff.dat, len, 0,
	       (struct sockaddr*)&remote,sizeof(struct sockaddr_in));
   if (i == -1)
     perror ("");

   return 0;
}
 
EUint32 EDMAPROC 
SOCKET_UDPrecvsAsU32 (OBJID IdObj, EDMAT_BUFFER *Buff, EPUint32 len)
{
  DtSSOCK	     *m;
  struct sockaddr_in remote;
  ESint32            i;
 
  m = (DtSSOCK*) edma_get_data_ref (IdObj);
 
   remote.sin_family = AF_INET;
   remote.sin_port = m->RemotePort;
   remote.sin_addr.s_addr = m->RemoteAddr;

   i = recvfrom (m->s, Buff->dat, *len, 0,
		 (struct sockaddr*)&remote,(int*)len);
   /* Actualize Remote Host Data */
   m->RemotePort = remote.sin_port;
   m->RemoteAddr = remote.sin_addr.s_addr;
     
  return i;
}

EUint32  EDMAPROC 
SOCKET_UDPSetRemoteZU32 (OBJID IdObj, EPChar Name, EUint32 port)
{
  DtSSOCK	     *m;
  struct hostent     *maq;   
  struct sockaddr_in remote;
  
  m = (DtSSOCK *) edma_get_data_ref (IdObj);
  
  
  m->RemotePort = htons (port);
  if (Name == NULL)
    {
      m->RemoteAddr = htons (INADDR_ANY);
      return 0;
    }
     
  /* Comprobamos si es hay que realizar resolucin de nombres*/
  if (isdigit(Name[0])) /* Si el primer caracter es un nmero -> direccion IP*/
    {
      m->RemoteAddr = inet_addr (Name); 
    }
  else
    {
      maq = gethostbyname (Name);
      if (maq == NULL)
	{
	  edma_printf_obj (IdObj, "(SetRemote)Can't locate host %s", Name);
	  return 1;
	}
      else
	{
	  remote.sin_addr = (*(struct in_addr *) (maq->h_addr));
	  m->RemoteAddr = remote.sin_addr.s_addr;
	}
    }

  return 0;
}
 
 
EUint32  EDMAPROC 
SOCKET_UDPborn (OBJID IdObj)
{
  DtSSOCK	*m;
  
  m = (DtSSOCK*) edma_get_data_ref (IdObj);
  
  m->s = socket (AF_INET, SOCK_DGRAM, 0);
  if (m->s == -1)
    {
      edma_printf_obj (IdObj, "%s", "Can't create datagram socket");
      return 1;
    }

  return 0;
}
 
EUint32  EDMAPROC 
SOCKET_UDPrip (OBJID IdObj)
{
  DtSSOCK	*m;
  
  m = (DtSSOCK*) edma_get_data_ref (IdObj);
  
  close (m->s);
  return 0;
}

/*-------------------------------------------------------------------------------*/

EUint32 EDMAPROC 
SOCKET_UDPSendAS32rS32 (OBJID IdObj, EDMAT_BUFFER Buff, EUint32 len)
{
   DtSSOCK	*m;
   EUint32       i;
 
   m = (DtSSOCK *) edma_get_data_ref (IdObj);

   i = (ESint32) edma_met3 (IdObj, "send", Buff, len);
   if (i == -1)
     perror("");

   return (ESint32) i;
}
 
EUint32 EDMAPROC 
SOCKET_UDPRecvsAsS32rS32 (OBJID IdObj, EDMAT_BUFFER *Buff, EPUint32 len)
{
  DtSSOCK	*m;
  ESint32  i;
 
  m = (DtSSOCK *) edma_get_data_ref (IdObj);
 
  i = (ESint32) edma_met3 (IdObj, "recv", Buff, len);
  *len = i;

  return i;
}
 
EUint32  EDMAPROC 
SOCKET_UDPOpenZS32rS32 (OBJID IdObj, EPChar Name, ESint32 mode)
{
  DtSSOCK	*m;
  EChar         addr[1024];
  EChar         temp[1024];
  EUint32       port;
  EPChar        aux;
  ESint32       r;
 
  m = (DtSSOCK *) edma_get_data_ref (IdObj);
  if (mode >= 2) 
    {
      edma_printf_obj (IdObj,"%s", "[ERROR] Append Mode (3) not support over this channel");
      return -1;
    }
  
  /* Parse target resource*/
  strcpy (temp, Name);
  aux = strchr (temp, ':');
  if (aux == NULL) 
    {
      port = 0;   /* Any port. For server (read mode) openning*/
      if (mode != 1) 
	{
	  edma_printf_obj (IdObj, "%s", "[ERROR] No port specified for Read Openning");
	  return -1;
	}
    } 
  else 
    {
      port = atoi (aux+1);
      *aux = 0;
    }
  strncpy (addr, temp, 1024);

  switch (mode) 
    {
    case 0: /* Reade Mode*/
      r = (ESint32) edma_met3 (IdObj, "bind", addr, port);
      if (r == -1)
	return r;
      break;
      
    case 1: /* Write Mode*/
      /* Read Mode for TCP SOcket is a conection. Client Side*/
      
      r = (ESint32)edma_met3 (IdObj, "SetRemote", addr, port);
      if (r == -1)
	return r;
      break;
    case 2: /* Append Mode. No sense on TCP Sockets*/
      break;
  }

  return 0;
}
 
EUint32  EDMAPROC 
SOCKET_UDPCloserS32 (OBJID IdObj)
{
  DtSSOCK	*m;
  
  m = (DtSSOCK*) edma_get_data_ref (IdObj);

  return 0;
}

EUint32  EDMAPROC 
SOCKET_UDPWaitsOrS32 (OBJID IdObj, OBJID *id)
{
  DtSSOCK	*m;
  ESint32       r;
  
  m=(DtSSOCK*)edma_get_data_ref(IdObj);
  /* Read Mode for TCP SOcket is a conection. Client Side*/
  return r;
}

EUint32  EDMAPROC 
SOCKET_UDPConfigOrS32 (OBJID IdObj, OBJID id)
{
  DtSSOCK	*m;
  
  m = (DtSSOCK*) edma_get_data_ref (IdObj);

  return 0;
}
