/*
  EDMA Advanced Class SOCKET_TCP
  Copyright (C) 1998-2005 David Martnez Oliveira

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; see the file COPYING.  If not, write to
  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
*/

/**************************************************
    Entorno de Desarrollo Modular y Abierto
    EDMA 0.5r1
    (c) David Martnez Oliveira
    File generated by : EDMA IDF WIzard Tcl/Tk 0.1
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : TCP_SOCKET
    Description : Stream Socket Implementation
    Author      : David Martnez Oliveira
    Date        : 28 de Abril de 1999
-----------------------------------------------------
  REVISIONS :
  8/4/2001
  Added CHANNEL interface implementation for using SOCKET_TCP as
  communication class
  ---------------------------------------------------------------
  30/6/2001
  The connect method didn't return -1 on error. This's been fixed
***************************************************/
 
 
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <errno.h>
/* Linux expecific includes */

#ifdef LINUX
#include <sys/types.h>
#include <sys/socket.h>

#include <sys/ioctl.h>

#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#endif

#include <edma.h>
/* Data structs for class SSOCK */
 
 
typedef struct
  {
    EUint32     s; 
    EPChar      resource;
  } DtSSOCK;
 
/* Method Implementation for class $gnc */
 
 
EUint32  EDMAPROC 
SOCKET_TCPbindZU32 (OBJID IdObj, EPChar Name, EUint32 port)
{
  DtSSOCK    	      *m;
  struct sockaddr_in  local;
  struct hostent      *maq;
  EUint32             n;
  EChar               res[1024];
  
  m = (DtSSOCK *)edma_get_data_ref (IdObj);
  sprintf (res,"%s:%ld", Name, port);
  edma_wprop3 (IdObj,"resource",res);

  /* Put your code here */
  local.sin_family = AF_INET;
  local.sin_port = htons (port);
  
  if (Name == NULL)
    local.sin_addr.s_addr = htons (INADDR_ANY);
  else  
    /* Comprobamos si es hay que realizar resolucin de nombres */
    if (isdigit (Name[0])) /* Si el primer caracter es un nmero -> direccion IP */
      local.sin_addr.s_addr = inet_addr (Name); 
    else
      {
	maq = gethostbyname (Name);
	if (maq == NULL)
	  {
	    edma_printf_obj (IdObj, "(bind)Can't locate host %s", Name);
	    return 1;
	  }
	else
	  {
	    local.sin_addr = (*(struct in_addr*)(maq->h_addr));
	    edma_printf_obj (IdObj, "Address located : %x", local.sin_addr);
	  }
      }
  
  /* Socket binding */
  bzero (&(local.sin_zero), 8); 
  
  n = bind (m->s, (struct sockaddr*)&local, sizeof(struct sockaddr_in));
  if (n == -1)
    edma_printf_obj (IdObj, "%s", "(bind) Error");
  
  return n;
}
 
EUint32 EDMAPROC 
SOCKET_TCPsendAU32 (OBJID IdObj, EDMAT_BUFFER Buff, EUint32 len)
{
   DtSSOCK	*m;
   EUint32       i;
 
   m = (DtSSOCK*) edma_get_data_ref (IdObj);

   /* Put your code here */
   i = send (m->s, Buff.dat, len, 0);
   if (i == -1)
     perror("send:");

   return i;
}
 
EUint32 EDMAPROC 
SOCKET_TCPrecvsAsU32(OBJID IdObj, EDMAT_BUFFER *Buff, EPUint32 len)
{
  DtSSOCK	*m;
  ESint32  i;
 
  m = (DtSSOCK*) edma_get_data_ref (IdObj);
 
  i = recv (m->s, Buff->dat, *len, 0);
  *len=i;
  return 0;
}
 
EUint32  EDMAPROC 
SOCKET_TCPconnectZU32(OBJID IdObj, EPChar Name, EUint32 port)
{
  DtSSOCK	     *m;
  struct hostent     *maq;   
  struct sockaddr_in remote;
  EChar              res[1024];
 
  m = (DtSSOCK*) edma_get_data_ref (IdObj);
 
  /* Put your code here */
  sprintf (res, "%s:%ld", Name, port);
  edma_wprop3 (IdObj, "resource", res);

  if (Name == NULL)
    remote.sin_addr.s_addr = htons (INADDR_ANY);
  else
    /* Comprobamos si es hay que realizar resolucin de nombres */
    if (isdigit (Name[0])) /* Si el primer caracter es un nmero -> direccion IP*/
      {
	remote.sin_addr.s_addr = inet_addr (Name); 
      }
    else
      {
	maq = gethostbyname (Name);
	if (maq == NULL)
	  {
	    return 1;
	  }
	else
	  {
	    remote.sin_addr = (*(struct in_addr*)(maq->h_addr));
	  }
	edma_printf_obj (IdObj, "--->MARK hostname DONE");
      }
  
  remote.sin_family = AF_INET;
  remote.sin_port = htons(port);

  return connect (m->s, (struct sockaddr*) &remote, sizeof(struct sockaddr));
}
 
EUint32  EDMAPROC 
SOCKET_TCPlistenU32(OBJID IdObj, EUint32 n)
{
  DtSSOCK	*m;
  EUint32       i;
  
  m = (DtSSOCK*) edma_get_data_ref (IdObj);

  i = listen (m->s, n);
  if (i == -1)
    perror ("Listen");

  return i;
}

EUint32  EDMAPROC 
SOCKET_TCPacceptsO(OBJID IdObj, OBJID *new)
{
  DtSSOCK	     *m;
  ESint32            i;
  socklen_t          size;
  struct sockaddr_in remote;
  EChar              res[1024];
  
  m = (DtSSOCK*) edma_get_data_ref (IdObj);

  i = accept (m->s, (struct sockaddr *)&remote, &size);
  if (i == -1)
    perror ("Accept");
  else
    edma_wprop3 (*new, "s", i);

  sprintf (res, "%s:%d", inet_ntoa (remote.sin_addr), ntohs(remote.sin_port));
  edma_wprop3 (*new, "resource", res);
  return i;
}

 
EUint32  EDMAPROC 
SOCKET_TCPborn(OBJID IdObj)
{
  DtSSOCK	*m;
  
  m = (DtSSOCK*) edma_get_data_ref (IdObj);
  
  /* Put your code here */
  m->s = socket (AF_INET, SOCK_STREAM, 0);
  if (m->s == -1)
    {
      edma_printf_obj (IdObj, "%s", "Can't create datagram socket");
      return 1;
    }
  return 0;
}
 
EUint32  EDMAPROC 
SOCKET_TCPrip(OBJID IdObj)
{
  DtSSOCK	*m;
  
  m = (DtSSOCK*) edma_get_data_ref (IdObj);
  
  /* Put your code here */
  close (m->s);
  return 0;
}

/*-------------------------------------------------------------------------------*/

EUint32 EDMAPROC 
SOCKET_TCPSendAS32rS32 (OBJID IdObj, EDMAT_BUFFER Buff, EUint32 len)
{
   DtSSOCK	*m;
   EUint32       i;
 
   m = (DtSSOCK*) edma_get_data_ref (IdObj);

   i = send (m->s, Buff.dat, len, 0);
   if (i == -1)
     perror ("");

   return (ESint32) i;
}
 
EUint32 EDMAPROC 
SOCKET_TCPRecvsAsS32rS32(OBJID IdObj, EDMAT_BUFFER *Buff,EPUint32 len)
{
  DtSSOCK	      *m;
  ESint32             i, pending_size, current_off;
 
  m = (DtSSOCK*) edma_get_data_ref (IdObj);
 
  /* Put your code here */
  pending_size = *len;
  current_off = 0;
  while ((pending_size > 0) && (i != -1))
    {
      i = recv (m->s, ((unsigned char*)Buff->dat + current_off), *len, 0);
      if (i != -1)
	{
	  ioctl (m->s, FIONREAD, &pending_size);
	  current_off += i;
	  *len = current_off;
	  if (i == 0)
	    break;
	}
      else
	perror ("SOCKET_TCP -> recv");
    }
     
  return *len;
}
 
EUint32  EDMAPROC 
SOCKET_TCPOpenZS32rS32(OBJID IdObj, EPChar Name, ESint32 mode)
{
  DtSSOCK	*m;
  EChar         addr[1024];
  EChar         temp[1024];
  EUint32       port;
  EPChar        aux;
  ESint32       r;
 
  m = (DtSSOCK*) edma_get_data_ref (IdObj);
  if (mode >= 2) 
    {
      edma_printf_obj (IdObj, "%s", "[ERROR] Append Mode (3) not support over this channel");
      return -1;
    }
  
  /* Parse target resource*/
  strcpy (temp, Name);
  aux = strchr (temp, ':');
  if (aux == NULL) 
    {
      port = 0;   /* Any port. For server (read mode) openning*/
      if (mode != 1) 
	{
	  edma_printf_obj (IdObj, "%s", "[ERROR] No port specified for Read Openning");
	  return -1;
	}
    } 
  else 
    {
      port = atoi (aux + 1);
      *aux = 0;
    }

  strcpy (addr, temp);

  switch (mode) 
    {
    case 0: /* Reade Mode*/
      r = (ESint32) edma_met3 (IdObj, "bind", addr, port);
      if (r == -1)
	return r;
      r = (ESint32) edma_met3 (IdObj, "listen", 5);
      if (r == -1)
	return r;
      break;
    case 1: /* Write Mode*/
      /* Read Mode for TCP SOcket is a conection. Client Side*/
      r = (ESint32) edma_met3 (IdObj, "connect", addr, port);
      return r;
      break;
    case 2: /* Append Mode. No sense on TCP Sockets*/
      break;
    }

  return 0;
}
 
EUint32  EDMAPROC 
SOCKET_TCPCloserS32(OBJID IdObj)
{
  DtSSOCK	*m;
  
  m = (DtSSOCK*) edma_get_data_ref (IdObj);

  shutdown (m->s, 2);
  close (m->s);

  return 0;
}

EUint32  EDMAPROC 
SOCKET_TCPWaitsOrS32(OBJID IdObj, OBJID *id)
{
  DtSSOCK	*m;
  ESint32       r;
  
  m = (DtSSOCK*) edma_get_data_ref (IdObj);
  /* Read Mode for TCP SOcket is a conection. Client Side*/
  r = (ESint32) edma_met3 (IdObj, "accept", id);
  return r;
}

EUint32  EDMAPROC 
SOCKET_TCPConfigOrS32(OBJID IdObj, OBJID id)
{
  DtSSOCK	*m;
  
  m = (DtSSOCK*) edma_get_data_ref (IdObj);

  return 0;
}
