/*
  EDMA Advanced Class CLASS_SERVICE
  Copyright (C) 1998-2005 David Martnez Oliveira

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; see the file COPYING.  If not, write to
  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
*/

/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.9.4
    (c) David Martnez Oliveira
    File generated by : EDMA C Implementation Builder class
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : CLASS_SERVICE
    Description : Serves GNU/EDMA classes
    Author      : David Martnez Oliviera
    Date        : August, 21th, 2002
    Version     : 0.0
-----------------------------------------------------
  REVISIONS :
***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
#include <string.h> 
/* Add here the includes you need for your class*/

/*
***************************************************
  EDMA Header Files
***************************************************
*/
 
#include <edma.h>

/*
***************************************************
  Private Data Struct for class CLASS_SERVICE
***************************************************
*/
 
/*
typedef struct {
 Put your field here
} DtCLASS_SERVICE;
*/

#define CS_QUIT     0
#define CS_INIT     1

#define CS_ERROR_NO_ERROR         0
#define CS_ERROR_RECV_ERROR       1
#define CS_ERROR_SEND_ERROR       2
#define CS_ERROR_CLASS_NOT_FOUND  3

/*
***************************************************
  Method Declaration for class CLASS_SERVICE
***************************************************
*/
 
ESint32 EDMAPROC
CLASS_SERVICEserviceOrS23(OBJID IdObj, OBJID id)
{
  EChar         idf_path[EDMA_PATH_LEN];
  EChar         imp_path[EDMA_PATH_LEN];
  /*
  EChar         source_path[EDMA_PATH_LEN];
  EChar         aux[EDMA_PATH_LEN];
  EChar         namespace[EDMA_CLASS_NAMESPACE_LEN];
  */
  EPChar        system_path;
  EDMAT_BUFFER  rbuf, sbuf;
  ESint32       len, status, error;
  CLASSID       cid;
  EChar         class_name[EDMA_CLASS_NAME_LEN];

  /* Build path strings */
  system_path = edma_get_system_path();
  snprintf (idf_path, EDMA_PATH_LEN, "%s/share/idf/edma", system_path);
  snprintf (imp_path, EDMA_PATH_LEN, "%s/lib/edma", system_path);
  
  /* Show paths to visually test them*/
  edma_printf_obj (IdObj, "IDF files in            : %s", idf_path);
  edma_printf_obj (IdObj, "Implementation files in : %s", imp_path);

  /* Init local variables */
  status = CS_INIT;
  cid = -1;

  edma_buffer_alloc (&rbuf, 256);
  while (status != CS_QUIT)
    {
      /* Reset receive buffer */
      memset (rbuf.dat, 0, 256);
      len = 128;
      //edma_printf_obj (IdObj, "**** Waiting for command ****");
      /* Read the data from the network */
      if (((ESint32) edma_met3 (id, "recv", &rbuf, &len)) == -1)
	{
	  edma_printf_obj (IdObj, "[ERROR] receiving data");
	  status = CS_QUIT;
	  error = CS_ERROR_RECV_ERROR;
	  continue;
	}

      edma_printf_obj (IdObj, "**** Received command: %s [%ld] bytes", 
		       (EPChar) rbuf.dat, len);
      /* Commands */
      if ((strncmp ((EPChar) rbuf.dat, "QUIT", 4)) == 0)
	{
	  /* QUIT command. Finishes communication */
	  edma_printf_obj (IdObj, "[INFO] QUIT Received. Finishing conection");
	  status = CS_QUIT;
	  error = CS_ERROR_NO_ERROR;

	  edma_buffer_alloc (&sbuf, 1024);
	  sprintf ((EPChar)sbuf.dat, "+OK");
	  edma_met3 (id, "send", sbuf, 4);
	  edma_buffer_free (&sbuf);
	  continue;
 	}

      if ((strncmp ((EPChar) rbuf.dat, "QUERY", 5)) == 0)
	{
	  /* QUERY command. client is asking for a class */
	  /* FORMAT: 'QUERY ClassName\0'*/
	  /* Get class name */
	  strncpy (class_name, (EPChar)rbuf.dat + 6, EDMA_CLASS_NAME_LEN);

	  
	  /* Build response */
	  if ((cid = edma_get_class_id (class_name)) == -1)
	    {
	      edma_printf_obj (IdObj, "Class '%s' does not exist "
			       "in this server",
			       class_name);
	      error = CS_ERROR_CLASS_NOT_FOUND;
	      continue;
	    }
	  edma_printf_obj (IdObj, "[INFO] Quering for class: '%s'."
			   " Found with id %ld", 
			   class_name, cid);	 
     
	  status = CS_INIT;

	  edma_buffer_alloc (&sbuf, 1024);
	  sprintf ((EPChar)sbuf.dat, "%ld ' class: %s", cid, class_name);
	  edma_met3 (id, "send", sbuf, strlen ((EPChar)sbuf.dat));
	  edma_buffer_free (&sbuf);

	  continue;
	}
    }
  
  return 0;
}



/********** END C IMPLEMENTATION SKELETON ******************/
