/*
  EDMA Advanced Class MEMORY_STREAM
  Copyright (C) 1998-2005 David Martnez Oliveira

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; see the file COPYING.  If not, write to
  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
*/

/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.9.4
    (c) David Martnez Oliveira
    File generated by : EDMA C Implementation Builder class
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : MEMORY_STREAM
    Description : A memory stream
    Author      : David Martnez Oliveira
    Date        : Dec, 27th, 2002
    Version     : 0.0
-----------------------------------------------------
  REVISIONS :
***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
 
/* Add here the includes you need for your class*/
#include <string.h>
/*
***************************************************
  EDMA Header Files
***************************************************
*/
 
#include <edma.h>

/*
***************************************************
  Private Data Struct for class MEMORY_STREAM
***************************************************
*/
 
typedef struct
{
	EDMAT_BUFFER	buf;
	EUint32		ptr;
}DtMEMORY_STREAM;
/*
***************************************************
  Method Declaration for class MEMORY_STREAM
***************************************************
*/
 
ESint32 EDMAPROC
MEMORY_STREAMopenZZrS32(OBJID IdObj, EPChar name, EPChar mode)
{
  DtMEMORY_STREAM	*m;

  m = (DtMEMORY_STREAM *) edma_get_data_ref (IdObj);
  edma_printf_obj (IdObj, "%s", "'open' not supported on memory streams");
  return 0;
}


ESint32 EDMAPROC
MEMORY_STREAMcloserS32(OBJID IdObj)
{
  DtMEMORY_STREAM	*m;

  m = (DtMEMORY_STREAM *) edma_get_data_ref (IdObj);
  edma_printf_obj (IdObj, "%s", "'close' not supported on memory streams");
  return 0;
}


ESint32 EDMAPROC
MEMORY_STREAMreadsAsS32rS32(OBJID IdObj, EDMAT_BUFFER *b, EPSint32 len)
{
  DtMEMORY_STREAM	*m;

  m = (DtMEMORY_STREAM *) edma_get_data_ref (IdObj);

  if (*len > (m->buf.Size - m->ptr)) /* Not enough data... truncate*/
    *len = m->buf.Size - m->ptr;

  if (*len <= 0) /* Invalid size */
    return -1;

  if (b->Size == 0) /* We received an empty buffer */
    {
      edma_buffer_alloc (b, *len);
      /* Check for errors*/
    }
  else
    if (b->Size < *len)
      {
	edma_printf_obj (IdObj, "** ERROR ** : Not enought space output buffer");
	return -1;
      }
  /* Copy data */
  memcpy (b->dat, m->buf.dat + m->ptr, *len);
  /* Update memory stream pointer */
  m->ptr += *len;
  return *len;
}


ESint32 EDMAPROC
MEMORY_STREAMwriteAsS32rS32(OBJID IdObj, EDMAT_BUFFER b, EPSint32 len)
{
  DtMEMORY_STREAM	*m;
  ESint32               new_size, old_size;

  m = (DtMEMORY_STREAM *) edma_get_data_ref (IdObj);

  if (*len <= 0)
    return 0;
  
  if (*len > b.Size)
    *len = b.Size;
  /* Check if we have enough space in our memory buffer */
  if ((m->buf.Size - m->ptr) < *len )
    {
      old_size = m->buf.Size;
      new_size = m->ptr + *len + 1;
      if ((edma_buffer_realloc (&m->buf, new_size)) == -1)
	{
	  edma_printf_obj (IdObj, "** ERROR ** : Can't allocate more memory. Write failed");
	  *len = 0;
	  return -1;
	}
      /* Init new allocated buffer */
      memset (m->buf.dat + old_size, 0, new_size - old_size);
    }
  /* Copy the new data*/
  memcpy (m->buf.dat + m->ptr, b.dat, *len);
  m->ptr += *len;

  return 0;
}


ESint32 EDMAPROC
MEMORY_STREAMputsZS32rS32(OBJID IdObj, EPChar s, ESint32 len)
{
  DtMEMORY_STREAM	*m;

  m = (DtMEMORY_STREAM *) edma_get_data_ref (IdObj);
  return 0;
}


ESint32 EDMAPROC
MEMORY_STREAMputcCS32rS32(OBJID IdObj, EChar c, ESint32 len)
{
  DtMEMORY_STREAM	*m;

  m = (DtMEMORY_STREAM *) edma_get_data_ref (IdObj);

  return 0;
}


ESint32 EDMAPROC
MEMORY_STREAMgetssZsS32rS32(OBJID IdObj, EPChar s, EPSint32 len)
{
  DtMEMORY_STREAM	*m;

  m = (DtMEMORY_STREAM *) edma_get_data_ref (IdObj);

  return 0;
}


ESint32 EDMAPROC
MEMORY_STREAMgetcsCrS32(OBJID IdObj, EPChar c)
{
  DtMEMORY_STREAM	*m;

  m = (DtMEMORY_STREAM *) edma_get_data_ref (IdObj);
  return 0;
}


ESint32 EDMAPROC
MEMORY_STREAMflushrS32(OBJID IdObj)
{
  DtMEMORY_STREAM	*m;

  m = (DtMEMORY_STREAM *) edma_get_data_ref (IdObj);
  return 0;
}


ESint32 EDMAPROC
MEMORY_STREAMseekS32ZrS32(OBJID IdObj, ESint32 p, EPChar pos)
{
  DtMEMORY_STREAM	*m;

  m = (DtMEMORY_STREAM *) edma_get_data_ref (IdObj);
  return 0;
}


ESint32 EDMAPROC
MEMORY_STREAMtellsS32rS32(OBJID IdObj, EPSint32 p)
{
  DtMEMORY_STREAM	*m;

  m = (DtMEMORY_STREAM *) edma_get_data_ref (IdObj);
  *p = m->ptr;
  return m->ptr;
}


ESint32 EDMAPROC
MEMORY_STREAMrewindrS32(OBJID IdObj)
{
  DtMEMORY_STREAM	*m;

  m = (DtMEMORY_STREAM *) edma_get_data_ref (IdObj);
  m->ptr = 0;
  return 0;
}


ESint32 EDMAPROC
MEMORY_STREAMeofrS32(OBJID IdObj)
{
  DtMEMORY_STREAM	*m;

  m = (DtMEMORY_STREAM *) edma_get_data_ref (IdObj);

  if (m->ptr == (m->buf.Size - 1))
    return 1;
  else
    return 0;
}


ESint32 EDMAPROC
MEMORY_STREAMerrorrS32(OBJID IdObj, ESint32 err)
{
  DtMEMORY_STREAM	*m;

  m = (DtMEMORY_STREAM *) edma_get_data_ref (IdObj);
  return 0;
}


ESint32 EDMAPROC
MEMORY_STREAMLoadZsArS32(OBJID IdObj, EPChar fname, EDMAT_BUFFER *buf)
{
  DtMEMORY_STREAM	*m;

  m = (DtMEMORY_STREAM *) edma_get_data_ref (IdObj);

  edma_printf_obj (IdObj, "%s", "'Load' not supported on memory streams");

  return 0;
}


ESint32 EDMAPROC
MEMORY_STREAMSaveZArS32(OBJID IdObj, EPChar fnmae, EDMAT_BUFFER buf)
{
  DtMEMORY_STREAM	*m;

  m = (DtMEMORY_STREAM *) edma_get_data_ref (IdObj);
  edma_printf_obj (IdObj, "%s", "'Save' not supported on memory streams");
  return 0;
}

ESint32 EDMAPROC
MEMORY_STREAMborn (OBJID IdObj)
{
  DtMEMORY_STREAM	*m;

  m = (DtMEMORY_STREAM *) edma_get_data_ref (IdObj);
  m->ptr = 0;
  memset (&m->buf, 0, sizeof (EDMAT_BUFFER));
  return 0;
}

ESint32 EDMAPROC
MEMORY_STREAMrip (OBJID IdObj)
{
  DtMEMORY_STREAM	*m;

  m = (DtMEMORY_STREAM *) edma_get_data_ref (IdObj);

  edma_buffer_free (&m->buf);
  return 0;
}

/********** END C IMPLEMENTATION SKELETON ******************/
