/*
  test for NDIRECTORY Class  Version 0.0
  Copyright (C) 2005 David Martnez Oliveira
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; see the file COPYING.  If not, write to
  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
    
*/

#include <stdio.h>
#include <edma.h>

main ()
{
  OBJID    id;
  EPChar   name;
  ESint32  type;
  
  EDMAInit();
  if ((id = edma_new_obj ("NDIRECTORY")) == -1)
    {
      fprintf (stderr, "Can't create object\n");
      exit (1);
    }
  edma_met3 (id, "opendir", ".");
  edma_printf ("%s", "------------------------------\n");

  while ( -1 != edma_met3 (id, "readdir", &name, &type))
    printf ("[%d] -> %s \n", type, name);

  edma_met3 (id, "closedir");
  edma_printf ("%s", "------------------------------\n");
  
  EDMAEnd();
}
