/*
  EDMA Advanced Class NDIRECTORY
  Copyright (C) 1998-2005 David Martnez Oliveira

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; see the file COPYING.  If not, write to
  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
*/

/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.5.1r1
    (c) David Martnez Oliveira
    File generated by : EDMA IDF Wizard Gnomized 0.1
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : NDIRECTORY
    Description :
    Author      :
    Date        :
-----------------------------------------------------
  REVISIONS :
***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
 
#include <stdio.h>
#include <string.h>

#include <sys/types.h>
#include <dirent.h>

/*
***************************************************
  EDMA Header Files
***************************************************
*/
 
#include <edma.h>

/*
***************************************************
  Private Data Struct for class NDIRECTORY
***************************************************
*/
 
typedef struct
  {
    EPChar		dir_name;
    DIR                 *handler;
}DtNDIRECTORY;
/*
***************************************************
  Method Declaration for class handler
***************************************************
*/
 
ESint32 EDMAPROC
NDIRECTORYopendirZrS32(OBJID IdObj, EPChar name)
{
  DtNDIRECTORY	*m;
  
  m = (DtNDIRECTORY *) edma_get_data_ref (IdObj);

  if ((m->handler = opendir (name)) == NULL)
    {
      edma_printf_obj (IdObj, "Can't open directory '%s'", name);
      return -1;
    }
  edma_wprop3 (IdObj, "dir_name", name);

  return 0;
}


ESint32 EDMAPROC
NDIRECTORYclosedirrS32(OBJID IdObj)
{
  DtNDIRECTORY	*m;

  m = (DtNDIRECTORY *) edma_get_data_ref (IdObj);

  return closedir (m->handler);
  
}


ESint32 EDMAPROC
NDIRECTORYreaddirsZsS32rS32(OBJID IdObj, EPChar *name, EPSint32 type)
{
  DtNDIRECTORY	*m;
  struct dirent *item;

  m = (DtNDIRECTORY *) edma_get_data_ref (IdObj);
  if ((item = readdir (m->handler)) == NULL)
    return -1;
  *name = item->d_name;
  *type = item->d_type;

  return 0;
}


ESint32 EDMAPROC
NDIRECTORYreadallsArS32(OBJID IdObj)
{
  DtNDIRECTORY	*m;

  m = (DtNDIRECTORY *) edma_get_data_ref (IdObj);

  edma_printf_obj (IdObj, "readall method still not implemented");
  return -1;
}



/********** END C IMPLEMENTATION SKELETON ******************/
