/*
    Singleton Test Version 0.0
    Copyright (C) 1998-2005 David Martnez Oliveira

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; see the file COPYING.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <signal.h>
#include <time.h>
#include <unistd.h>

#include <edma.h>

main(int argc,char *argv[])
{
  OBJID    id,id_sc,id1;

  EDMAInit();
  printf ("\n-------------------------------------\n");
  /* Put your C code here */

  edma_smet3 ("SINGLETON","Register","SUBCLASS1",-1);
  edma_smet3 ("SINGLETON","Register","SUPER_CLASS",-1);

  id = (OBJID) edma_smet3 ("SINGLETON","Instance","SUBCLASS1");
  id_sc = (OBJID) edma_smet3 ("SINGLETON","Instance","SUPER_CLASS");
  printf ("\nSingleton object id : %d. for superclass: %d\n",id,id_sc);

  if ((id1 = edma_new_obj ("SUBCLASS2"))==-1) {
    fprintf (stderr,"Can't create object of SUBCLASS2");
  } else {
    edma_smet3 ("SINGLETON","Register","SUBCLASS2",id1);
    id = (OBJID) edma_smet3 ("SINGLETON","Instance","SUBCLASS1");
    id_sc = (OBJID) edma_smet3 ("SINGLETON","Instance","SUBCLASS2");
    printf ("\nSingleton object SUBCLASS1 : %d. SUBCLASS2: %d\n",id,id_sc);
  }
  printf ("\n-------------------------------------\n");
  /* Shutdown EDMA Suystem */
  EDMAEnd();
  return 0;
}
