/*
  EDMA Advanced Class SINGLETON
  Copyright (C) 1998-2005 David Martnez Oliveira

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; see the file COPYING.  If not, write to
  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
*/

/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.5.1r1
    (c) David Martnez Oliveira
    File generated by : EDMA IDF Wizard Gnomized 0.1
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : SINGLETON
    Description : General Singleton Pattern
                  This is a general superclass to make any
		  GNU EDMA Class a singleton, that is, you
		  get one and only instance from this class
		  when you uses this singleton
    Author      : David Martnez Oliviera
    Date        : October, 14th,2001
-----------------------------------------------------
  REVISIONS :
  ** October, 17th,2001
  ** Added OnLoad and OnUnload static methods to initialize
  ** SINGLETON's internal tables.
  ** 
  ** It served as test for the new code in GNU EDMA CORE
***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
 
#include <stdio.h>
#include <string.h>

/*
***************************************************
  EDMA Header Files
***************************************************
*/
 
#include <edma.h>

/*** Global vars ****/
#define MAX_SINGLETONS 50
typedef struct singleton_entry_t {
  EChar     ClassName[50];
  OBJID     id;
} SINGLETON_ENTRY;

SINGLETON_ENTRY singletons[MAX_SINGLETONS];
ESint32 nItems;


/*
***************************************************
  Method Declaration for class 
  ***************************************************
*/

/* Class OnLoad Initialization
** - This method'll be executen the first time the
**   shared library is loaded by each process
**/

ESint32 
SINGLETONOnLoad (CLASSID Idc) 
{
  ESint32    i;
  
  for (i=0;i<MAX_SINGLETONS;i++)
    singletons[i].id=-1;
  
  nItems=0;
  return 0;
} 
 
/* Class OnUnload cleanup
** - This method'll be executed when this class
**   is unloaded. Typically when the system goes down 
**/
ESint32 
SINGLETONOnUnload (CLASSID Idc) 
{
  
  /* Free internal table in future version with dynamic allocation */
  return 0;
}


ESint32 EDMAPROC 
SINGLETONRegisterZU32rS32(CLASSID idc,EPChar cn,OBJID id)
{
  ESint32     i;

  if (nItems == MAX_SINGLETONS) 
    {
      edma_printf ("[SINGLETON] ** ERROR: I can't define more singletons");
      return -1;
    }
    
  for (i = 0; i < nItems; i++) 
    {
      if (singletons[i].id != -1)
	if (strcmp (singletons[i].ClassName,cn) == 0)
	  break;
    }
  if (i == nItems) 
    {
      strcpy (singletons[nItems].ClassName,cn);
      if (id==-1)
	singletons[nItems].id = edma_new_obj (cn,NULL);
      else
	singletons[nItems].id = id;
    }

  nItems++;
  return 0;
}


ESint32 EDMAPROC 
SINGLETONInstanceZrO(CLASSID idc,EPChar cn)
{
  ESint32     i;

  for (i = 0; i < nItems; i++) 
    {
      if (singletons[i].id != -1)
	if (strcmp (singletons[i].ClassName,cn) == 0)
	  break;
    }
  if (i == nItems) 
    {
      edma_printf ("[SINGLETON] Don't found any instance of class %s",cn);
      return -1;
    }

  return singletons[i].id;
}

/********** END C IMPLEMENTATION SKELETON ******************/
