/*
  EDMA Advanced Class LOGGER
  Copyright (C) 1998-2005 David Martnez Oliveira

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; see the file COPYING.  If not, write to
  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
*/

/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.5.1r1
    (c) David Martnez Oliveira
    File generated by : EDMA IDF Wizard Gnomized 0.1
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : LOGGER
    Description : Base class for logging system
    Author      : David Martnez Oliveira
    Date        : June, 17th, 2002
-----------------------------------------------------
  REVISIONS :
***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
 
#include <stdio.h>
#include <string.h>

/*
***************************************************
  EDMA Header Files
***************************************************
*/
 
#include <edma.h>

/*
***************************************************
  Private Data Struct for class LOGGER
***************************************************
*/
 
typedef struct
  {
     EPChar		app_name;
     OBJID		level;
     OBJID		output;
     OBJID		formatter;
}DtLOGGER;
/*
***************************************************
  Method Declaration for class formatter
***************************************************
*/
 
ESint32 EDMAPROC
LOGGERlogZrS32(OBJID IdObj, EPChar msg)
{
  DtLOGGER	*m;

  m = (DtLOGGER *) edma_get_data_ref (IdObj);
  return edma_met3 (IdObj, ".log", msg);
}


ESint32 EDMAPROC
LOGGERdebugZrS32(OBJID IdObj, EPChar msg)
{
  DtLOGGER	*m;

  m = (DtLOGGER *) edma_get_data_ref (IdObj);
  return edma_met3 (IdObj, ".debug", msg);
}


ESint32 EDMAPROC
LOGGERinfoZrS32(OBJID IdObj, EPChar msg)
{
  DtLOGGER	*m;
  
  m = (DtLOGGER *) edma_get_data_ref (IdObj);
  return edma_met3 (IdObj, ".info", msg);
}


ESint32 EDMAPROC
LOGGERwarnZrS32(OBJID IdObj, EPChar msg)
{
  DtLOGGER	*m;
  
  m = (DtLOGGER *) edma_get_data_ref (IdObj);
  return edma_met3 (IdObj, "INNER>warn", msg);
}


ESint32 EDMAPROC
LOGGERerrorZrS32(OBJID IdObj, EPChar msg)
{
  DtLOGGER	*m;
 
  m = (DtLOGGER *) edma_get_data_ref (IdObj);
  return edma_met3 (IdObj, "INNER>error", msg);
}


ESint32 EDMAPROC
LOGGERfatalZrS32(OBJID IdObj, EPChar msg)
{
  DtLOGGER	*m;
  
  m = (DtLOGGER *) edma_get_data_ref (IdObj);
  return edma_met3 (IdObj, "INNER>fatal", msg);
}


ESint32 EDMAPROC
LOGGERborn(OBJID IdObj)
{
  DtLOGGER	*m;

  m = (DtLOGGER *) edma_get_data_ref (IdObj);
  return 0;
}


ESint32 EDMAPROC
LOGGERrip(OBJID IdObj)
{
  DtLOGGER	*m;

  m = (DtLOGGER *) edma_get_data_ref (IdObj);
  return 0;
}



/********** END C IMPLEMENTATION SKELETON ******************/
