/*
  EDMA Advanced Class EDMA_EXCEPTION
  Copyright (C) 1998-2005 David Martnez Oliveira

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; see the file COPYING.  If not, write to
  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
*/

/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.5.1r1
    (c) David Martnez Oliveira
    File generated by : EDMA IDF Wizard Gnomized 0.1
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : EDMA_EXCEPTION
    Description : General GNU/EDMA exception class
    Author      : David Martnez Oliveira
    Date        : March, 25th, 2002
-----------------------------------------------------
  REVISIONS :
***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
 
#include <stdio.h>
#include <string.h>

/*
***************************************************
  EDMA Header Files
***************************************************
*/
 
#include <edma.h>

/*
***************************************************
  Private Data Struct for class EDMA_EXCEPTION
***************************************************
*/
 
typedef struct
  {
     ESint32		type;
     EPChar		desc;
}DtEDMA_EXCEPTION;
/*
***************************************************
  Method Declaration for class desc
***************************************************
*/
 
ESint32 EDMAPROC
EDMA_EXCEPTIONprint(OBJID IdObj)
{
  DtEDMA_EXCEPTION	*m;
  
  m = (DtEDMA_EXCEPTION *) edma_get_data_ref (IdObj);

  
  edma_print  (">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
  edma_print  ("[EDMA_EXCEPTION] print");
  edma_printf ("    Type        : %ld", m->type);
  edma_printf ("    Description : %s", m->desc);
  edma_print  (">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>");

  return 0;
}

ESint32 EDMAPROC
EDMA_EXCEPTIONbrief(OBJID IdObj)
{
  DtEDMA_EXCEPTION	*m;
  
  m = (DtEDMA_EXCEPTION *) edma_get_data_ref (IdObj);
  
  edma_printf ("[EDMA_EXCEPTION] <%ld> :: %s", m->type, m->desc);

  return 0;
}


ESint32 EDMAPROC
EDMA_EXCEPTIONthrow(OBJID IdObj)
{
  DtEDMA_EXCEPTION	*m;
  
  m = (DtEDMA_EXCEPTION *) edma_get_data_ref (IdObj);

  edma_exception_throw (IdObj);
  return 0;
}


ESint32 EDMAPROC
EDMA_EXCEPTIONsetS32Z(OBJID IdObj, ESint32 type, EPChar msg)
{
  DtEDMA_EXCEPTION	*m;

  m = (DtEDMA_EXCEPTION *) edma_get_data_ref (IdObj);
  edma_wprop3 (IdObj, "type", type);
  edma_wprop3 (IdObj, "desc", msg);
  return 0;
}



/********** END C IMPLEMENTATION SKELETON ******************/
