
/*
  EDMA Advanced Class TRASP_CODEC
  Copyright (C) 1998-2000 David Martnez Oliveira

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; see the file COPYING.  If not, write to
  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
*/

/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.5.1r1
    (c) David Martnez Oliveira
    File generated by : EDMA IDF Wizard Gnomized 0.1
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : TRASP_CODEC
    Description : Transposition codec
    Author      : David Martnez Oliviera
    Date        : December, 15th, 2001
-----------------------------------------------------
  REVISIONS :
***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
 
#include <stdio.h>
#include <string.h>

/*
***************************************************
  EDMA Header Files
***************************************************
*/
 
#include <edma.h>

/*
***************************************************
  Private Data Struct for class TRASP_CODEC
***************************************************
*/
 
typedef struct
  {
     ESint32		priv_pass;
}DtTRASP_CODEC;
/*
***************************************************
  Method Declaration for class priv_pass
***************************************************
*/
 
ESint32 EDMAPROC 
TRASP_CODECcodeAsAsS32rS32(OBJID IdObj, EDMAT_BUFFER ibuf,
			   EDMAT_BUFFER *obuf, EPSint32 len)
{
  DtTRASP_CODEC	*m;
  ESint32       i,val;

  m=(DtTRASP_CODEC*)edma_get_data_ref(IdObj);
  /* Alloc new buffer for crypted data*/
  if (obuf->dat==NULL) {/* If the output buffer isn't allocated*/
    edma_printf_obj (IdObj,"Allocating space for output buffer (%d bytes)",*len);
    if ((edma_buffer_alloc (obuf,*len)) == -1) {
      edma_printf_obj (IdObj,"[ERROR] Can't alloc output buffer");
      return -1;
    }
  }

  if (obuf->Size < *len)  {/* If we don't have enough space, realloc */
    edma_printf_obj (IdObj,"Reallocatiing space for output buffer (%d -> %d)",
	      obuf->Size,*len);
    if (edma_buffer_realloc (obuf,*len)) {
      edma_printf_obj (IdObj,"[ERROR] Can't realloc output buffer");
      return -1;
    }
  }
  /* FIXME: test against Buffer->Size and len to be sure there is enough space*/
  /* Processing buffer*/
  /*edma_printf_obj (IdObj,"Coding %d bytes",*len);*/
  for (i=0;i<*len;i++) {
    val=(ESint32)*((EPChar)ibuf.dat+i);
    //printf ("Current val: %d ",val);
    val+=m->priv_pass;
    //if (val>256) val=val-256;
    val=val%256;
    //printf ("Crypt val: %d\n",val);
    *((EPChar)obuf->dat+i)=(EChar)val;
  }
    
  return 0;
}


ESint32 EDMAPROC 
TRASP_CODECdecodeAsAsS32rS32(OBJID IdObj,EDMAT_BUFFER ibuf, 
			     EDMAT_BUFFER *obuf,EPSint32 len)
{
  DtTRASP_CODEC	*m;
  ESint32       i,val;
 
  m=(DtTRASP_CODEC*)edma_get_data_ref(IdObj);
  /* Alloc new buffer for crypted data*/
  if (obuf->dat==NULL) /* If the output buffer isn't allocated*/
    if ((edma_buffer_alloc (obuf,*len))==-1) {
      edma_printf_obj (IdObj,"[ERROR] Can't alloc output buffer");
      return -1;
    }
  if (obuf->Size < *len)  /* If we don't have enough space, realloc */
    if (edma_buffer_realloc (obuf,*len)) {
      edma_printf_obj (IdObj,"[ERROR] Can't realloc output buffer");
      return -1;
    }
  /* FIXME: test against Buffer->Size and len to be sure there is enough space*/
  /* Processing buffer*/
  for (i=0;i<*len;i++) {
    val=(ESint32)*((EPChar)ibuf.dat+i);
    val-=m->priv_pass;
    //if (val<0) val+=256;
    val=val%256;
    *((EPChar)obuf->dat+i)=(EChar)val;
  }
    
  return 0;

}


ESint32 EDMAPROC TRASP_CODECSetPasswordZrS32(OBJID IdObj,EPChar p)
{
  DtTRASP_CODEC	*m;
  EPChar       aux;

  m=(DtTRASP_CODEC*)edma_get_data_ref(IdObj);
  /* Simple password calculation: Add al the characters*/
  aux=p;
  m->priv_pass=0;
  while (*aux!=0)
    m->priv_pass+=*(aux++);

  m->priv_pass %= 256;
  /*edma_printf_obj (IdObj,"(SetPassword) Password calculated: %d",m->priv_pass);*/
  return 0;
}



/********** END C IMPLEMENTATION SKELETON ******************/
