
/*
  EDMA Advanced Class HELLO_WORLD
  Copyright (C) 1998-2000 David Martnez Oliveira

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; see the file COPYING.  If not, write to
  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
*/

/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.5.1r1
    (c) David Martnez Oliveira
    File generated by : EDMA IDF Wizard Gnomized 0.1
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : HELLO_WORLD
    Description : Simple Sample Class
    Author      : David Martnez Oliveira
    Date        : April, 22th 2000
-----------------------------------------------------
  REVISIONS :
***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
 
#include <stdio.h>
#include <string.h>

/*
*****************************************************
C++ Header files and declarations
******************************************************
 */

#include <iostream.h>

// C++ Class for testing
//--------------------------------------------------------------
class cpp_Hello_World {
public: 
  int num1;
  int num2;

  cpp_Hello_World () {cout << "[C++ Code] Building Object...";};
  int say() {cout << "[C++] Hello World !!\n";};
  int say2(char *a) {cout << "[C++] Hello World !!\nTexto:";cout <<a; cout <<"\n";}
  
};
//------------------------------------------------------------------

/*
***************************************************
  EDMA Header Files
***************************************************
*/

#include <edma.h>

/*
************************************************************
Make C++ compiler not to generate signtaures for EDMA methods
************************************************************
 */

extern "C" {
  ESint32 HELLO_WORLD_CPPborn(OBJID);
  ESint32 HELLO_WORLD_CPPrip(OBJID);
  ESint32 HELLO_WORLD_CPPsay(OBJID);
  ESint32 HELLO_WORLD_CPPsay2Z(OBJID,EPChar);

}

/*
***************************************************
  Private Data Struct for class HELLO_WORLD_CPP
***************************************************
*/
 
typedef struct
  {
    EUint32		num;
    EPChar		str;
    //    EPvoid             cpp_object;
    cpp_Hello_World     *cpp_object;
}DtHELLO_WORLD_CPP;


/*
***************************************************
  Method Declaration for class str
***************************************************
*/
 
ESint32 EDMAPROC 
HELLO_WORLD_CPPborn (OBJID IdObj)
{
DtHELLO_WORLD_CPP	*m;

m=(DtHELLO_WORLD_CPP*)edma_get_data_ref(IdObj);

 edma_printf_obj(IdObj,"  [Constructor]");
 edma_printf_obj(IdObj,"  [Building C++ Object]....");
 m->cpp_object=new cpp_Hello_World();

 return 0;
}


ESint32 EDMAPROC 
HELLO_WORLD_CPPrip (OBJID IdObj)
{
DtHELLO_WORLD_CPP	*m;

m=(DtHELLO_WORLD_CPP*)edma_get_data_ref(IdObj);

 edma_printf_obj(IdObj,"  [Destructor]"); 
 return 0;
}


ESint32 EDMAPROC 
HELLO_WORLD_CPPsay (OBJID IdObj)
{
DtHELLO_WORLD_CPP	*m;

m=(DtHELLO_WORLD_CPP*)edma_get_data_ref(IdObj);

 edma_printf_obj(IdObj,"  [say] -------------------------------"); 
 edma_printf_obj(IdObj,"  [say] Hello world!!!!");
 edma_printf_obj(IdObj,"  [say] Property num : %d",m->num);
 edma_printf_obj(IdObj,"  [say] Property str : %s",m->str);
 edma_printf_obj(IdObj,"  [say] Trying say on C++ object...");
 m->cpp_object->say();
 edma_printf_obj(IdObj,"  [say] -------------------------------"); 
 
 return 0;
}

ESint32 EDMAPROC 
HELLO_WORLD_CPPsay2Z (OBJID IdObj,EPChar texto)
{
DtHELLO_WORLD_CPP	*m;

m=(DtHELLO_WORLD_CPP*)edma_get_data_ref(IdObj);

 edma_printf_obj(IdObj,"  [say2] -------------------------------"); 
 edma_printf_obj(IdObj,"  [say2] Hello world!!!!");
 edma_printf_obj(IdObj,"  [say2] Text : %s",texto);
 m->cpp_object->say2(texto);
 edma_printf_obj(IdObj,"  [say2] -------------------------------"); 

 return 0; 
}


/********** END C IMPLEMENTATION SKELETON ******************/
