
/*
  EDMA Advanced Class EDMA_C_INTERFACE_BUILDER
  Copyright (C) 1998-2005 David Martnez Oliveira

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; see the file COPYING.  If not, write to
  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
*/

/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.9.4
    (c) David Martnez Oliveira
    File generated by : EDMA C Implementation Builder class
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : EDMA_C_INTERFACE_BUILDER
    Description : Generates a C wrapper for type-safe access to
                  a given class
    Author      : David Martnez Oliviera
    Date        : May, 18th, 2003
    Version     : 0.0
-----------------------------------------------------
  REVISIONS :
***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
 
/* Add here the includes you need for your class*/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>


/*
***************************************************
  EDMA Header Files
***************************************************
*/
 
#include <edma.h>


/*
*********************************************************
Support Data
*********************************************************
 */
 
#define NTYPES 16

EPChar   type[NTYPES]={ "EUint32","ESint32",
			"EUint16","ESint16",
			"EUint8","ESint8",
			"EByte","EWord","EDWord",
			"EChar","EBool",
			"EReal32","EReal64",
			"EPChar","EDMAT_BUFFER","OBJID"};
EPChar   typeid[NTYPES]={ "EUINT32","ESINT32",
			  "EUINT16","ESINT16",
			  "EUINT8","ESINT8",
			  "EBYTE","EWORD","EDWORD",
			  "ECHAR","EBOOL",
			  "EREAL32","EREAL64",
			  "EZSTRING","EBUFFER","EOBJECT"};


/*
***************************************************
  Private Data Struct for class EDMA_C_INTERFACE_BUILDER
***************************************************
*/
 
typedef struct
{
	EPChar		FileName;
	EUint32		h;
}DtEDMA_C_INTERFACE_BUILDER;
/*
***************************************************
  Method Declaration for class EDMA_C_INTERFACE_BUILDER
***************************************************
*/
 
ESint32 EDMAPROC
EDMA_C_INTERFACE_BUILDERbuildU32Z(OBJID IdObj, OBJID id, EPChar filename)
{
  DtEDMA_C_INTERFACE_BUILDER	*m;
  EPChar                        h_filename, aux;
  FILE                          *f;
  EUint32                       i, j, n, k, n_prop;
  ESint32                       major_version, minor_version;
  EUint32                       m_virtual, m_abstract, m_static;
  EChar                         return_type[EDMA_GENERAL_ID_LEN];
  EChar                         temp[EDMA_GENERAL_ID_LEN];
  EChar                         temp1[EDMA_GENERAL_ID_LEN];
  EChar                         temp2[EDMA_GENERAL_ID_LEN];
  EChar                         ClassName[EDMA_CLASS_NAME_LEN];

  m = (DtEDMA_C_INTERFACE_BUILDER *) edma_get_data_ref (IdObj);

  /* Open file to store warpper */
  if ((f = fopen (filename,"wt")) == NULL)
    {
      edma_printf_obj(IdObj,"Can't open file %s for writting",filename);
      return -1;
    }

  h_filename = strdup (filename);
  aux = strstr (h_filename, ".c");
  if (aux)
    {
      *(aux + 1) = 'h';
      *(aux + 2) = 0;
    }
  else
    {
      edma_printf_obj (IdObj, "%s", "**ERROR** Invalid file name. Extension missing");
      return -1;
    }

  printf ("Header FIle is: %s", h_filename);

  /* FIXME: Before beginning to generate the file, 
     we'd test if our class is pure abstract
     In that case, code generation has no sense*/
  
  edma_rprop3 (id, "ClassName", ClassName);
  edma_rprop3 (id, "MajorVersion", &major_version);
  edma_rprop3 (id, "MinorVersion", &minor_version);

  /* Write GPL Notice on source file*/
  fprintf (f,"\n/*");
  fprintf (f,"\n  EDMA Warpper for Advanced Class %s", ClassName);
  fprintf (f,"\n  Copyright (C) 1998-2000 David Martnez Oliveira");
  fprintf (f,"\n");
  fprintf (f,"\n  This program is free software; you can redistribute it and/or modify");
  fprintf (f,"\n  it under the terms of the GNU General Public License as published by");
  fprintf (f,"\n  the Free Software Foundation; either version 2 of the License, or");
  fprintf (f,"\n  (at your option) any later version.");
  fprintf (f,"\n");
  fprintf (f,"\n  This program is distributed in the hope that it will be useful,");
  fprintf (f,"\n  but WITHOUT ANY WARRANTY; without even the implied warranty of");
  fprintf (f,"\n  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the");
  fprintf (f,"\n  GNU General Public License for more details.");
  fprintf (f,"\n");
  fprintf (f,"\n  You should have received a copy of the GNU General Public License");
  fprintf (f,"\n  along with this program; see the file COPYING.  If not, write to");
  fprintf (f,"\n  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,");
  fprintf (f,"\n  Boston, MA 02111-1307, USA.");
  fprintf (f,"\n*/\n");

  /* Generate Class Record */
  fprintf (f, "\n/*\n**************************************************");
  fprintf (f, "\n    Entorno de Desarrollo Modular y Abierto (EDMA)");
  fprintf (f, "\n    (c) David Martnez Oliveira");
  fprintf (f, "\n    File generated by : EDMA C Interface Builder class");
  fprintf (f, "\n------------------------------------------------------");
  fprintf (f, "\n    Module Type : CLASS INTERFACE");
  fprintf (f, "\n    Class List  : %s", ClassName);
  fprintf (f, "\n    Description :");
  fprintf (f, "\n    Author      :");
  fprintf (f, "\n    Date        :");
  fprintf (f, "\n    Version     : %ld.%ld", major_version, minor_version);
  fprintf (f, "\n-----------------------------------------------------");
  fprintf (f, "\n  REVISIONS :");
  fprintf (f, "\n***************************************************");
  fprintf (f, "\n*/\n ");

  /* Generate include files */
  fprintf (f, "\n/*\n***************************************************");  
  fprintf (f, "\n  General Header Files");
  fprintf (f, "\n***************************************************");
  fprintf (f, "\n*/\n "); 

  fprintf (f, "\n/* Add here the includes you need for your class*/");
  fprintf (f, "\n");

  fprintf (f, "\n/*\n***************************************************");  
  fprintf (f, "\n  EDMA Header Files");
  fprintf (f, "\n***************************************************");
  fprintf (f, "\n*/\n "); 
  fprintf (f,"\n#include <edma.h>");
  fprintf (f,"\n");

  /* Generate ADT structure and new/free methods */
  edma_rprop3 (id, "nMet", &n);
  fprintf (f, "\n/***************************************************************/\n");
  fprintf (f, "typedef struct %s_t {\n", ClassName);
  fprintf (f, "  OBJID    id;\n");
  for (i = 0; i < n; i++)
    {
      strcpy (return_type, "ESint32") ;
      edma_met3 (id, "GetMet", i, temp, temp1, &m_virtual
		 , &m_abstract, &m_static);
      fprintf (f, "  %s (%s*)(struct %s_OBJ_t *id,", return_type, temp, ClassName);
      fprintf (f, ");\n");
    }
  fprintf (f, "} *%s_OBJ;\n\n", ClassName);

  /* New method */
  fprintf (f, "%s_OBJ new_%s_OBJ ()\n", ClassName, ClassName);
  fprintf (f, "%s_OBJ temp;\n", ClassName);
  fprintf (f, "temp = (%s_OBJ*) malloc (sizeof (%s_t));\n", ClassName, ClassName);
  for (i = 0; i < n; i++)
    {
      edma_met3 (id, "GetMet", i, temp, temp1, &m_virtual
		 , &m_abstract, &m_static);
      fprintf (f, "  temp->%s = %s_METHOD;", temp, temp);
      fprintf (f, ");\n");
    }

  fprintf (f, "return *tmp;\n}");

  /* Generate accessor methods */
  edma_rprop3 (id, "nProp", &n); 
  fprintf (f, "\n/*\n***************************************************");  
  fprintf (f, "\n  Accessor methods for class  %s",ClassName);
  fprintf (f, "\n***************************************************");
  fprintf (f, "\n*/\n");   
 

  /* Write properties to file */
  n_prop = n;
  if (n) 
    { /* We only write DtStruct if we have any prop */
      for (i = 0; i < n; i++)
	{
	  edma_met3 (id, "GetProp", i, temp, temp1, temp2, &k);
	  for (j = 0; j < NTYPES; j++)
	    if (strcmp (temp1, typeid[j]) == 0)
	      break;

	  fprintf (f, "%s EDMAPROC\n", type[j]);
	  fprintf (f, "%s_get_%s (OBJID IdObj, EPChar name)\n", ClassName, temp);
	  fprintf (f, "{\n\t%s  aux;\n\n\tedma_rprop3 (IdObj, name, &aux);\n\treturn aux;\n}\n\n", type[j]);
	  
	  fprintf (f, "%s", "void EDMAPROC\n");
	  fprintf (f, "%s_set_%s (OBJID IdObj, EPChar name, %s value)\n", ClassName, temp, type[j]);
	  fprintf (f, "{\n\tedma_wprop3 (IdObj, name, value);\n}\n\n");
	}
    }
  
  fprintf (f, "\n\n/********** END C IMPLEMENTATION SKELETON ******************/");
  fclose (f);

  free (h_filename);
  return 0;
}



/********** END C IMPLEMENTATION SKELETON ******************/
