/*
  EDMA Advanced Class AUTOTOOLS_PROJECT
  Copyright (C) 1998-2005 David Martnez Oliveira

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; see the file COPYING.  If not, write to
  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
*/

/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.5.1r1
    (c) David Martnez Oliveira
    File generated by : EDMA IDF Wizard Gnomized 0.1
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : AUTOTOOLS_PROJECT
    Description : Create a directory tree to build a GNU EDMA Class
    Author      : David Martnez Oliveira
    Date        : November, 15th,2001
-----------------------------------------------------
  REVISIONS :
  * 2002, Aug, 8th
  * It was broken... correcting. Suport for versioning information
  * ---------------------------------------------------------------
  * July, 18th, 2003
  * Fixed compiling errors with gcc-3.x
***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
 
#include <stdio.h>
#include <string.h>

/*
***************************************************
  EDMA Header Files
***************************************************
*/
 
#include <edma.h>

/*
***************************************************
  Private Data Struct for class AUTOTOOLS_PROJECT
***************************************************
*/
 
typedef struct
  {
     EPChar		FileName;
     EUint32		h;
}DtAUTOTOOLS_PROJECT;
/*
***************************************************
  Method Declaration for class h
***************************************************
*/
 
ESint32 EDMAPROC 
AUTOTOOLS_PROJECTbuildU32Z (OBJID IdObj, OBJID id, EPChar filename)
{
  DtAUTOTOOLS_PROJECT	*m;
  EChar                 prj_name[80],ClassName[80],ModuleName[80];
  EChar                 name_space[256];
  EChar                 src_dir[128],aux[128];
  FILE                  *f;
  OBJID                 builder;
  ESint32               major_version, minor_version;
  EChar                 ver_string[20];

  m = (DtAUTOTOOLS_PROJECT *) edma_get_data_ref (IdObj);

  /* Retrieve information required to generate files*/
  major_version = minor_version = 0; 
  edma_rprop3 (id, "ClassName", ClassName);
  edma_rprop3 (id, "NameSpace", name_space);
  edma_rprop3 (id, "MajorVersion", &major_version);
  edma_rprop3 (id, "MinorVersion", &minor_version);
  
  snprintf (ver_string, 20, "_%ld_%ld", major_version, minor_version);

  sprintf (prj_name, "%s_v%s", ClassName, ver_string);
  edma_printf_obj (IdObj, "+ Working on dir : %s for class %s", 
		   prj_name, ClassName);
  /* FIXME: We must check if prj_name directory already exists and show a dialog*/
  if ((ESint32)(edma_smet3 ("FILESYSTEM", "CreateDirectory", prj_name)) == -1) 
    {
      edma_printf_obj (IdObj, "[ERROR] Can't create directory %s", prj_name);
      return -1;
    }
  
  /* Create a directory for the sources */
  strcpy (src_dir, prj_name);
  strcat (src_dir, "/src");
  
  if ((ESint32)(edma_smet3 ("FILESYSTEM", "CreateDirectory", src_dir)) == -1) 
    {
      edma_printf_obj (IdObj, "[ERROR] Can't create directory %s", src_dir);
      return -1;
    }  

  /* Now we write configure.in for this project*/
  sprintf (aux, "%s/configure.in", prj_name);
  edma_printf_obj (IdObj, "Writing file: %s for project: %s",
		   aux, prj_name);
  if ((f = fopen (aux, "wt")) == NULL) {
    edma_printf_obj (IdObj, "Can't write configure.in");
    return -1;
  }
  
  fprintf (f,"\nAC_INIT(src/%s%s_imp.c)",ClassName, ver_string);
  fprintf (f,"\n\nAC_CONFIG_AUX_DIR(config)\n");
  fprintf (f,"\nAM_INIT_AUTOMAKE(EDMA_CLASS_%s,%ld.%ld.0)\n",
	   ClassName, major_version, minor_version);
  fprintf (f,
	   "\nAC_PREFIX_DEFAULT(/usr/local)"
	   "\ndnl Checks for programs."
	   "\nAC_PROG_CXX"
	   "\nAC_PROG_AWK"
	   "\nAC_PROG_CC"
	   "\nAC_PROG_CPP"
	   "\nAC_PROG_INSTALL"
	   "\nAC_PROG_MAKE_SET"
	   "\nAC_PROG_LN_S"
	   "\nAC_LIBTOOL_DLOPEN"
	   "\nAC_DISABLE_STATIC"
	   "\nAM_PROG_LIBTOOL"
	   "\n"
	   "\ndnl Checks for libraries."
	   "\nAC_CHECK_LIB(dl,main)"
	   "\nAC_CHECK_LIB(EDMA, main)"
	   "\n"
	   "\ndnl How to check for our programs"
	   "\ndnl Be sure to not left any space between mactro and parenthesis"
	   "\nAC_CHECK_PROG(EDMACONFIG, edma-config, yes, no, $PATH)"
	   "\nif test ${EDMACONFIG} = no; then"
	   "\n	AC_MSG_WARN([---- Can't find edma-config                        ---])"
	   "\n	AC_MSG_WARN([---- Be sure it is installed and it's in your path ---])"
	   "\n	AC_MSG_ERROR([--- Aborting. edma-config needed. -------------------])"
	   "\nfi"
	   "\n"
	   "\ndnl Checks for header files."
	   "\nAC_C_CONST"
	   "\nAC_HEADER_STDC"
	   "\n"
	   "\ndnl Checks for typedefs, structures, and compiler characteristics."
	   "\n"
	   "\ndnl Checks for library functions."
	   "\ndnl AC_CHECK_FUNCS(strstr)"
	   "\nAC_MSG_RESULT(--- Building for $build_cpu in a $build_os)"
	   "\ncase \"$build_os\" in"
	   "\n	linux*)"
	   "\n		CFLAGS=\"-DLINUX \""
	   "\n		;;"
	   "\n"
	   "\n	*)"
	   "\n		AC_MSG_WARN([Unknow target OS. Build could fail])"
	   "\n	;;"
	   "\n"
	   "\nesac"
	   "\nif test ${CC} = gcc; then"
	   "\n	CFLAGS=\"$CFLAGS -DGCC\""
	   "\nfi"
	   "\n"
	   "\ndnl Test prefix directory"
	   "\nif test \"${prefix}\" = NONE; then"
	   "\n	AC_MSG_RESULT([prefix not defined... using default_prefix])"
	   "\n	mi_prefix=${ac_default_prefix}"
	   "\nelse"
	   "\n	mi_prefix=${prefix}"
	   "\nfi"
	   "\n"
	   "\nCFLAGS=\"$CFLAGS -c -fPIC -I ${mi_prefix}/include\""
	   "\n"
	   "\nAC_MSG_RESULT([--- Mi CFLAGS = ${CFLAGS} ---])"
	   "\n"
	   "\nAC_OUTPUT(Makefile src/Makefile)" 
	   "");
  
	fclose(f);

  /* Now we write Makefile.am for this project*/
  sprintf (aux,"%s/Makefile.am", prj_name);
  edma_printf_obj (IdObj, "+ Creating %s file", aux);
  if ((f = fopen (aux, "wt")) == NULL) 
    {
      edma_printf_obj (IdObj, "Can't write Makefile.am");
      return -1;
    }
  fprintf (f, 
	   "SUBDIRS = src"
	   "\n"
	   "\nEXTRA_DIST= config"
	   "\n## Deleted these files when make maintainer-clean"
	   "\nMAINTAINERCLEANFILES =  Makefile.in aclocal.m4 configure config.cache"
	   "\n"
	   "\nmaintainer-clean-local:"
	   "\n\trm -fr $(ac_aux_dir)"
	   "\n\trm -f @PACKAGE@-*.tar.gz"
	   "");
  fclose(f);
  
  /* Then, Makefile.am for the src dir*/
  sprintf (aux, "%s/src/Makefile.am", prj_name);
  edma_printf_obj (IdObj,"+ Creating %s dir", aux);
  if ((f = fopen(aux,"wt")) == NULL) {
    edma_printf_obj (IdObj, "Can't write src/Makefile.am");
    return -1;
  }
  edma_rprop3 (id, "ModuleName", ModuleName);
  fprintf (f, "lib_LTLIBRARIES = lib%s.la\n\n", ClassName);
  fprintf (f, "NAMESPACE = %s\n", name_space);
  fprintf (f, "idfdir=${prefix}/share/edma/idf/${NAMESPACE}\n");
  fprintf (f, "libdir=${exec_prefix}/lib/edma/${NAMESPACE}\n");
  fprintf (f, "EXTRA_DIST = %s%s.idf %s%s.ines\n", 
	   ClassName, ver_string, ClassName, ver_string);
  fprintf (f, "idf_DATA = %s%s.idf\n\n", ClassName, ver_string);
  fprintf (f, "lib%s_la_SOURCES = %s%s_imp.c\n", ClassName, ClassName, ver_string);
  fprintf (f, "lib%s_la_LDFLAGS = -version-info %ld:%ld\n\n", 
	   ClassName, major_version, minor_version);
  fprintf (f, "MAINTAINERCLEANFILES =  Makefile.in config.h.in stamp-h.in\n");
  fprintf (f, "\n");
  fclose (f);

  /* Finally we create skel files*/
  if ((builder = edma_new_obj ("EDMAIDF_BUILDER")) == -1) 
    {
      edma_printf_obj (IdObj, "Can't create IDF file for class %s", ClassName);
      return -1;
    }
  sprintf (aux, "%s/src/%s%s.idf", prj_name, ClassName, ver_string);
  edma_met3 (builder, "build", id, aux);
  edma_free_obj (builder);

  /* FIXME: We should get the apropiate class from 
     Language property in id (CLASSMETADA)*/
  if ((builder = edma_new_obj ("EDMA_C_IMP_BUILDER")) == -1) 
    {
      edma_printf_obj (IdObj, "Can't create C skel file for class %s", ClassName);
      return -1;
    }
  sprintf (aux, "%s/src/%s%s_imp.c", prj_name, ClassName, ver_string);
  edma_met3 (builder, "build", id, aux);
  edma_free_obj (builder);

  if ((builder = edma_new_obj ("EDMA_INES_BUILDER")) == -1) 
    {
      edma_printf_obj (IdObj, "Can't create ines file for class %s", ClassName);
      return -1;
    }
  sprintf (aux, "%s/src/%s%s.ines", prj_name, ClassName, ver_string);
  edma_met3 (builder, "build", id, aux);
  edma_free_obj (builder);

  edma_printf_obj (IdObj, " Project Built....");
  return 0;
}

/********** END C IMPLEMENTATION SKELETON ******************/
