
/*
  EDMA Advanced Class EDMA_SCRIPT
  Copyright (C) 1998-2000 David Martnez Oliveira

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; see the file COPYING.  If not, write to
  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
*/

/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.9.4
    (c) David Martnez Oliveira
    File generated by : EDMA C Implementation Builder class
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : EDMA_SCRIPT
    Description : Runs System-Related scripts
    Author      : David Martnez Oliveira
    Date        : September, 18th, 2005
    Version     : 0.0
-----------------------------------------------------
  REVISIONS :
***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
 
/* Add here the includes you need for your class*/

/*
***************************************************
  EDMA Header Files
***************************************************
*/
 
#include <edma.h>

/*
***************************************************
  Private Data Struct for class EDMA_SCRIPT
***************************************************
*/
 
typedef struct
{
	EPChar		script_code;
	OBJID		interpreter;
	EDMAT_BUFFER		private;
}DtEDMA_SCRIPT;
/*
***************************************************
  Method Declaration for class EDMA_SCRIPT
***************************************************
*/
 
ESint32 EDMAPROC
EDMA_SCRIPTset_scriptZrS32(OBJID IdObj, EPChar script_name)
{
  DtEDMA_SCRIPT	*m;

  m = (DtEDMA_SCRIPT *) edma_get_data_ref (IdObj);

  return 0;
}


ESint32 EDMAPROC
EDMA_SCRIPTupdate_objectOOrS32(OBJID IdObj, OBJID newid, OBJID oldid)
{
  DtEDMA_SCRIPT	*m;

  m = (DtEDMA_SCRIPT *) edma_get_data_ref (IdObj);
  return 0;
}


ESint32 EDMAPROC
EDMA_SCRIPTrunrS32(OBJID IdObj)
{
  DtEDMA_SCRIPT	*m;

  m = (DtEDMA_SCRIPT *) edma_get_data_ref (IdObj);
  return 0;
}


ESint32 EDMAPROC
EDMA_SCRIPTborn(OBJID IdObj)
{
  DtEDMA_SCRIPT	*m;

 m = (DtEDMA_SCRIPT *) edma_get_data_ref (IdObj);
 m->script_code = NULL;
 m->interpreter = -1;

 return 0;
}


ESint32 EDMAPROC
EDMA_SCRIPTrip(OBJID IdObj)
{
  DtEDMA_SCRIPT	*m;

  m = (DtEDMA_SCRIPT *) edma_get_data_ref (IdObj);

  if (m->interpreter != -1) edma_free_obj (m->interpreter);

  return 0;
}


ESint32
EDMA_SCRIPT_class_factory ()
{
  CLASSID    cid;

  cid = edma_idf_get_free_class_id (EDMA_LOCAL_CLASS);

  edma_idf_set_class_name (cid, "EDMA_SCRIPT");
  
  edma_idf_set_class_namespace (cid, "system");
  edma_idf_set_class_version (cid, 0, 0);
  
  edma_add_local_class_property (cid, "script_code", DT_EZSTRING, E_L, 0);
  edma_add_local_class_property (cid, "interpreter", DT_EOBJECT, E_L, 0);
  edma_add_local_class_property (cid, "private", DT_EBUFFER, E_L, 0);
  
  /*UNKNOW (~@~@~@)*/
  /*UNKNOW (~@~@~@)*/
  /* Method registration */
  edma_add_local_class_method (cid, "set_script", "ZrS32", 
			       (PPROC)EDMA_SCRIPTset_scriptZrS32, 1, 0, 0);
  edma_add_local_class_method (cid, "update_object", "OOrS32", 
			       (PPROC)EDMA_SCRIPTupdate_objectOOrS32, 1, 0, 0);
  edma_add_local_class_method (cid, "run", "rS32", 
			       (PPROC)EDMA_SCRIPTrunrS32, 1, 0, 0);
  edma_add_local_class_method (cid, "born", "", 
			       (PPROC)EDMA_SCRIPTborn, 0, 0, 0);
  edma_add_local_class_method (cid, "rip", "", 
			       (PPROC)EDMA_SCRIPTrip, 0, 0, 0);
  
  edma_idf_set_class_id (cid);
 
  return 0;
}

/********** END C IMPLEMENTATION SKELETON ******************/
