/*
  EDMA Advanced Class CLASS_METADATA
  Copyright (C) 1998-2005 David Martnez Oliveira

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; see the file COPYING.  If not, write to
  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA 02111-1307, USA.
*/

/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.5.1r1
    (c) David Martnez Oliveira
    File generated by : EDMA IDF Wizard Gnomized 0.1
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : CLASS_METADATA
    Description : Store EDMA Classes Interface Information
    Author      : David Martnez Oliveira
    Date        : 26-02-2000
-----------------------------------------------------
  REVISIONS :
  * November, 4th, 2001
  * Update data structs to manage new modifiers Abstract, Static
***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
 
#include <stdio.h>
#include <string.h>

/*
***************************************************
  EDMA Header Files
***************************************************
*/
 
#include <edma.h>

/*
*********************************************
Support Data Structs
***********************************************
*/
typedef struct t_md_property {
  EChar     p_name[50];
  EChar     p_type[20];
  EChar     p_access[20];
  ESint32   p_n_elems;
} MD_PROPERTY;

typedef struct t_md_method {
  EChar     m_name[50];
  EChar     m_sig[50];
  EUint32   m_virtual;
  EUint32   m_abstract;
  EUint32   m_static;
} MD_METHOD;

typedef struct t_md_sc {
  EChar     sc_name[50];
} MD_SC;
/*
***************************************************
  Private Data Struct for class CLASS_METADATA
***************************************************
*/
 
typedef struct
  {
    EPChar		FileName;
    EUint32		h;
    EDMAT_BUFFER	Prop;
    EDMAT_BUFFER	Met;
    EDMAT_BUFFER	SCList;
    ESint32		nProp;
    ESint32		nMet;
    ESint32		nSC;
    EPChar		ClassName;
    EPChar		ModuleName;
    EUint32             maxProp;
    EUint32             maxMet;
    EUint32             maxSC;
    EPChar              Machine;
    EPChar              OperatingSystem;
    EPChar              SIUProxy;
    EPChar              IDFParser;
    EUint32             IsIDFParser;
    EUint32             IsSIUProxy;
    EUint32             IsEMI;
    EPChar              Language;
    EPChar              NameSpace;
    ESint32             MajorVersion;
    ESint32             MinorVersion;
}DtCLASS_METADATA;

/*
***************************************************
  Method Declaration for class CLASS_METADATA
***************************************************
*/
 
ESint32 EDMAPROC 
CLASS_METADATASetNPropU32(OBJID IdObj,ESint32 n)
{
  DtCLASS_METADATA	*m;

 m = (DtCLASS_METADATA *) edma_get_data_ref (IdObj);

 m->nProp = 0;
 m->maxProp = n;
 edma_buffer_alloc (&m->Prop, n * sizeof (MD_PROPERTY));

 return 0;
}

ESint32 EDMAPROC 
CLASS_METADATASetNMetU32(OBJID IdObj,EUint32 n)
{
  DtCLASS_METADATA	*m;
  
  m = (DtCLASS_METADATA *) edma_get_data_ref (IdObj);

  m->nMet = 0;
  m->maxMet = n;
  edma_buffer_alloc (&m->Met, n * sizeof (MD_METHOD));

  return 0;
}

ESint32 EDMAPROC 
CLASS_METADATASetNSCU32(OBJID IdObj,ESint32 n)
{
  DtCLASS_METADATA	*m;

  m = (DtCLASS_METADATA *) edma_get_data_ref (IdObj);

 m->nSC = 0;
 m->maxSC = n;
 edma_buffer_alloc (&m->SCList, n * sizeof (MD_SC));

 return 0;
}

ESint32 EDMAPROC 
CLASS_METADATAAddPropZZZU32(OBJID IdObj,EPChar name, 
			    EPChar type, EPChar access, EUint32 n)
{
  DtCLASS_METADATA	*m;
  MD_PROPERTY           *aux;
  
  m = (DtCLASS_METADATA *) edma_get_data_ref (IdObj);

  if (m->nProp >= m->maxProp)
    return -1;

  aux = (MD_PROPERTY *) m->Prop.dat;
  
  strcpy (aux[m->nProp].p_name, name);
  strcpy (aux[m->nProp].p_type, type);
  strcpy (aux[m->nProp].p_access, access);
  aux[m->nProp].p_n_elems = n;

  m->nProp++;
  return 0;

}
ESint32 EDMAPROC 
CLASS_METADATAAddMetZZU32U32U32(OBJID IdObj,
				EPChar name, EPChar sig, 
				EUint32 virtual, EUint32 m_abstract, 
				EUint32 m_static)
{
  DtCLASS_METADATA	*m;
  MD_METHOD             *aux;
  
  m = (DtCLASS_METADATA *) edma_get_data_ref (IdObj);
  if (m->nMet >= m->maxMet)
    return -1;
  
  aux = (MD_METHOD *) m->Met.dat;

  strcpy (aux[m->nMet].m_name, name);
  strcpy (aux[m->nMet].m_sig, sig);
  aux[m->nMet].m_virtual = virtual;
  aux[m->nMet].m_abstract = m_abstract;
  aux[m->nMet].m_static = m_static;

  m->nMet++;
  return 0;

}
ESint32 EDMAPROC 
CLASS_METADATAAddSCZ(OBJID IdObj,EPChar name)
{
  DtCLASS_METADATA	*m;
  MD_SC                 *aux;

  m = (DtCLASS_METADATA *) edma_get_data_ref (IdObj);
  if (m->nSC > m->maxSC)
    return -1;

  aux = (MD_SC*) m->SCList.dat;

  strcpy (aux[m->nSC].sc_name, name);
  
  m->nSC++;
  return 0;

}

ESint32 EDMAPROC 
CLASS_METADATAInitU32U32U32(OBJID IdObj)
{
DtCLASS_METADATA	*m;

 m = (DtCLASS_METADATA *) edma_get_data_ref (IdObj);

 edma_printf_obj (IdObj,"Not yet Implemented");

 return 0;
}

ESint32 EDMAPROC 
CLASS_METADATArip(OBJID IdObj)
{

  DtCLASS_METADATA	*m;
  
  m = (DtCLASS_METADATA *) edma_get_data_ref (IdObj);
  edma_buffer_free (&m->Prop);
  edma_buffer_free (&m->Met);
  edma_buffer_free (&m->SCList);
  
  return 0;
}

ESint32 EDMAPROC 
CLASS_METADATAClear(OBJID IdObj)
{
  DtCLASS_METADATA	*m;
  
  m = (DtCLASS_METADATA *) edma_get_data_ref (IdObj);
  edma_buffer_free (&m->Prop);
  edma_buffer_free (&m->Met);
  edma_buffer_free (&m->SCList);
  
  return 0;
}

ESint32 EDMAPROC CLASS_METADATAGetSCU32sZ(OBJID IdObj,EUint32 indx,EPChar name)
{
  DtCLASS_METADATA	*m;
  MD_SC                 *aux;
  
  m = (DtCLASS_METADATA *) edma_get_data_ref (IdObj);
  if (indx > m->maxSC)
    return -1;

  aux = (MD_SC *) m->SCList.dat;
  strcpy (name, aux[indx].sc_name);
  
  return 0;
}

ESint32 EDMAPROC 
CLASS_METADATAGetPropU32sZsZsZsU32 (OBJID IdObj,EUint32 indx,
				    EPChar name, EPChar type,
				    EPChar access,EPUint32 n)
{
  DtCLASS_METADATA	*m;
  MD_PROPERTY           *aux;

  m = (DtCLASS_METADATA *) edma_get_data_ref (IdObj);
  if (indx > m->maxProp)
    return -1;

  aux = (MD_PROPERTY *) m->Prop.dat;
  strcpy (name, aux[indx].p_name);
  strcpy (type, aux[indx].p_type);
  strcpy (access, aux[indx].p_access);
  *n = aux[indx].p_n_elems;

  return 0;
}

ESint32 EDMAPROC 
CLASS_METADATAGetMetU32sZsZsU32sU32sU32 (OBJID IdObj,EUint32 indx,
					 EPChar name, EPChar sig,
					 EPUint32 virtual,EPUint32 m_abstract, 
					 EPUint32 m_static)
{
  DtCLASS_METADATA	*m;
  MD_METHOD             *aux;
  
  m = (DtCLASS_METADATA *) edma_get_data_ref (IdObj);
  if (indx > m->maxMet)
    return -1;

  aux = (MD_METHOD *) m->Met.dat;

  strcpy (name, aux[indx].m_name);
  strcpy (sig, aux[indx].m_sig);
  *virtual    = aux[indx].m_virtual;
  *m_abstract = aux[indx].m_abstract;
  *m_static   = aux[indx].m_static;

  return 0;

}

ESint32 EDMAPROC 
CLASS_METADATAShow (OBJID IdObj)
{
  DtCLASS_METADATA	*m;
  EUint32               i;
  MD_PROPERTY           *aux_prop;
  MD_METHOD             *aux_met;
  MD_SC                 *aux_sc;
  
  m = (DtCLASS_METADATA *) edma_get_data_ref (IdObj);

  edma_printf_obj (IdObj, ">>METADATA report for class %s", m->ClassName);
  edma_printf_obj (IdObj, ">> Module Name      : %s", m->ModuleName);
  edma_printf_obj (IdObj, ">> Name space       : %s", m->NameSpace);
  edma_printf_obj (IdObj, ">> Version          : %d.%d", 
		   m->MajorVersion, m->MinorVersion);
  edma_printf_obj (IdObj, ">> Name space       : %s", m->NameSpace);
  edma_printf_obj (IdObj, ">> Machine          : %s", m->Machine);
  edma_printf_obj (IdObj, ">> Operating System : %s", m->OperatingSystem);
  edma_printf_obj (IdObj, ">> Name space       : %s", m->NameSpace);
  edma_printf_obj (IdObj, ">> SIU Proxy        : %s", m->SIUProxy);
  edma_printf_obj (IdObj, ">> IDF Parser       : %s", m->IDFParser);
  edma_printf_obj (IdObj, ">> Is IDF Parser    : %d", m->IsIDFParser);
  edma_printf_obj (IdObj, ">> Is SIU Proxy     : %d", m->IsSIUProxy);
  edma_printf_obj (IdObj, ">> Is EMI Component : %d", m->IsEMI);
  edma_printf_obj (IdObj, ">> %d SuperClasses", m->nSC);
  aux_sc = (MD_SC *) m->SCList.dat;
  for (i = 0;i < m->nSC; i++)
    {
      edma_printf_obj (IdObj, ">>  %02d -> %s ", i, aux_sc[i].sc_name);
    }

  edma_printf_obj (IdObj, ">> %d Properties", m->nProp);
  aux_prop = (MD_PROPERTY *) m->Prop.dat;
  for (i = 0; i < m->nProp; i++)
    {
      edma_printf_obj (IdObj,">>  %02d -> %s [%d] (%s:%s)", i, 
		       aux_prop[i].p_name,aux_prop[i].p_n_elems,
		       aux_prop[i].p_type,aux_prop[i].p_access);
    }
  edma_printf_obj (IdObj , ">> %d Methods", m->nMet);
  aux_met = (MD_METHOD *) m->Met.dat;
  for (i = 0;i < m->nMet; i++)
    {
      edma_printf_obj (IdObj, ">>  %02d -> [%s|%s|%s] %s [%s] ", i,
		       aux_met[i].m_virtual ? "V" : "-",
		       aux_met[i].m_abstract ? "A" : "-",
		       aux_met[i].m_static ? "S" : "-",
		       aux_met[i].m_name,aux_met[i].m_sig);
    }

  return 0;

}





