/*
 * EDMA: Entorno de Desarrollo Modular y Abierto
 * Object Oriented and Componetware Framework
 * Copyright (C) 1998, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2010, 2013, 2021
 *    David Martnez Oliveira
 *
 * This file is part of EDMA.
 *
 * EDMA is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EDMA is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with EDMA.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdio.h>
#include <edma.h>

int test (OBJID id, char *str, ESint32 val) {
  edma_printf_obj (id, "This is test: '%s' with value %d\n", str, val);
  
  return 0;
}

int test1 (OBJID id, ESint8 v1, ESint32 v2, ESint16 v3 ) {
  edma_printf_obj (id, "This is test1: %d, %d, %d\n", v1, v2, v3);
  
  return 0;
}

ESint32 test2 (OBJID id, ESint32 v1, ESint32 v2, ESint32 *v3 ) {
  *v3 = v1 + v2;
  edma_printf_obj (id, "This is test2: %d, %d, %d\n", v1, v2, *v3);
  
  return *v3;
}


int main (int argc, char *argv[])
{
  CLASSID       cid;
  OBJID		id, id1;
  
  EDMAInit();
  cid = edma_idf_get_free_class_id (EDMA_LOCAL_CLASS);
  edma_idf_set_class_name (cid, "TEST");
  edma_idf_set_class_namespace (cid, "LOCAL");
  edma_idf_set_class_version (cid, 0, 0);
  
  edma_add_local_class_method (cid, "test", "ZS32", (PPROC) test, 0, 0, 0);
  edma_add_local_class_method (cid, "test1", "S8S32S16rS32", (PPROC) test1, 0, 0, 0);
  edma_add_local_class_method (cid, "test2", "S32S32sS32rS32", (PPROC) test2, 0, 0, 0);
  //edma_add_local_class_method (cid, "test", "", (PPROC) test, 0, 0, 0);
  edma_idf_set_class_id (cid);
 

  id = edma_new_obj ("TEST");
  edma_obj_report (id);
  int v1, v2;
  v2 = edma_met3 (id, "test2",  100123, 123000, &v1);
  edma_printf ("v1: %d, v2 : %d\n", v1, v2);
  edma_met3 (id, "test1",  21, 423543, 30111);
  edma_met3 (id, "test", "Hello World!", 129);
  edma_met3 (id, "test", "Bye World!", 2129);

  edma_free_obj (id);


  /* Single Static Inheritance*/

  EDMAEnd();
}
