/*
 * EDMA: Entorno de Desarrollo Modular y Abierto
 * Object Oriented and Componetware Framework
 * Copyright (C) 1998, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2010, 2013, 2021
 *    David Martnez Oliveira
 *
 * This file is part of EDMA.
 *
 * EDMA is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EDMA is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with EDMA.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.5.1r1
    (c) David Martnez Oliveira
    File generated by : EDMA IDF Wizard Gnomized 0.1
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : RUNABLE
    Description :
    Author      :
    Date        :
-----------------------------------------------------
  REVISIONS :
  August, 6th, 2005
  Pending updates to use GNU/EDMA protable threads interface
***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
 
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <pthread.h>

/*
***************************************************
  EDMA Header Files
***************************************************
*/
 
#include <edma.h>

/*
***************************************************
  Private Data Struct for class RUNABLE
***************************************************
*/
 
typedef struct
  {
    EUint32		thread;
    OBJID		obj;
}DtRUNABLE;

typedef struct s_par 
{
  OBJID     idProxy;
  OBJID     obj;
  EPChar    name;
  EPVoid    pars;
} TH_PAR;

void *threaded_func (void *pars);
/*
***************************************************
  Method Declaration for class id
***************************************************
*/
 
ESint32 EDMAPROC 
RUNABLENewObjZ (OBJID IdObj, EPChar name)
{
  DtRUNABLE	*m;

  m = (DtRUNABLE*) edma_get_data_ref (IdObj);
  edma_printf_obj (IdObj, "NewObj: Data reference at: %p\n", m);

  if ((m->obj = edma_new_obj (name)) == -1) 
    return -1;

  return 0;
}


ESint32 EDMAPROC 
RUNABLEFreeObj (OBJID IdObj)
{
  DtRUNABLE	*m;
  void*           r;

  m = (DtRUNABLE*) edma_get_data_ref (IdObj);
  edma_printf_obj (IdObj, "FreeObj: Data reference at: %p\n", m);
  edma_printf (IdObj, "Waiting for running threads to finish\n");
  pthread_join (m->thread, &r);
  edma_free_obj (m->obj);
  return 0;
}


ESint32 EDMAPROC 
RUNABLEWProp3S32ZsS32 (OBJID IdObj, CLASSID id, EPChar name, EPVoid par)
{
  DtRUNABLE	*m;

  m = (DtRUNABLE*) edma_get_data_ref (IdObj);
  
  return edma_wprop3_pargs (m->obj, name, par);
}


ESint32 EDMAPROC 
RUNABLERProp3S32ZsS32 (OBJID IdObj, CLASSID id, EPChar name, EPVoid par)
{
  DtRUNABLE	*m;
  
  m = (DtRUNABLE*) edma_get_data_ref (IdObj);

  return edma_rprop3_pargs (m->obj, name, par);
}


ESint32 EDMAPROC 
RUNABLEMet3S32ZsS32 (OBJID IdObj, CLASSID id, EPChar name, EPVoid par)
{
  DtRUNABLE	*m;
  TH_PAR        *pars;
  
  m = (DtRUNABLE*) edma_get_data_ref (IdObj);

  if ((pars = (TH_PAR*) edma_palloc (sizeof (TH_PAR))) == NULL)
    {
      edma_printf_obj (IdObj, "%s", "Can't allocate memory for thread parameters");
      return -1;
    }

  pars->idProxy = IdObj;
  pars->obj = m->obj;
  pars->name = name;
  pars->pars = par;
  edma_printf_obj (IdObj, "Creating thread for method %s", name);
  /* Run method in new thread*/
  int r = pthread_create (&m->thread, NULL, threaded_func, pars);
  
  return 0;

}


ESint32 EDMAPROC 
RUNABLEMet3S (OBJID IdObj, CLASSID id, EPChar name, EPChar sig, EPVoid par)
{
  DtRUNABLE	*m;
  
  m = (DtRUNABLE*) edma_get_data_ref (IdObj);
  edma_printf_obj (IdObj, "Met3S still not implemented");
  return 0;
  /*return edma_met3s_pargs (m->id,name,sig,par);*/
}

void * 
threaded_func (void *pars) 
{
  TH_PAR     *p;

  edma_thread_register ();
  p = (TH_PAR*) pars;
  edma_printf ("[RUNABLE] Invoking threaded method %s on object %d", p->name, p->obj);
  edma_met3_pargs (p->obj, p->name, NULL, 1, p->pars);

  free (pars);
  edma_thread_unregister ();

  return 0;
}


/********** END C IMPLEMENTATION SKELETON ******************/
