/*
 * EDMA: Entorno de Desarrollo Modular y Abierto
 * Object Oriented and Componetware Framework
 * Copyright (C) 1998, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2010, 2013, 2021
 *    David Martnez Oliveira
 *
 * This file is part of EDMA.
 *
 * EDMA is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EDMA is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with EDMA.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.5.1r1
    (c) David Martnez Oliveira
    File generated by : EDMA IDF Wizard Gnomized 0.1
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : FILESYSTEM
    Description : Basic File System access methods
    Author      : David Martnez Oliviera
    Date        : September, 15th, 2001
-----------------------------------------------------
  REVISIONS :
September, 19th,2001:
* Added implementation for FreeSpace Method
* Added method GetDrive but still not implemented
--------------------------------------------
***************************************************
*/

 
/*
***************************************************
  General Header Files
***************************************************
*/
 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#ifdef LINUX
#include <sys/vfs.h>
#endif

#include <dirent.h>
#include <errno.h>

#ifdef DARWIN
#include <sys/param.h>
#include <sys/mount.h>
#endif

/*
***************************************************
  EDMA Header Files
***************************************************
*/
 
#include <edma.h>

/*
***************************************************
  Method Declaration for class 
***************************************************
*/
 
ESint32 EDMAPROC 
FILESYSTEMCopyFileZZS32rS32 (CLASSID id, EPChar source, 
			     EPChar target, ESint32 flags)
{
  edma_printf ("%s", "Still Not Implemented");
  return 0;
  
}


ESint32 EDMAPROC 
FILESYSTEMDeleteFileZS32rS32 (CLASSID id, EPChar name, ESint32 flags)
{
  return unlink (name);
  
}


ESint32 EDMAPROC 
FILESYSTEMFreeSpaceZrS32 (CLASSID id, EPChar name)
{
  struct statfs buf;
  long          bs,ba;
  
  if (statfs (name, &buf) == -1) 
    {
      edma_printf ("%s", "[FILESYSTEM::FreeSpace] Can't get filesystem info");
      return 1;
    }
  /* We return freespace in Kb*/
  bs = buf.f_bsize;
  ba = buf.f_bavail / 1024L;
  ba *= bs;

  return  ba;
}

ESint32 EDMAPROC 
FILESYSTEMGetDrivessArS32 (CLASSID id,EDMAT_BUFFER *buf)
{
  FILE *f;
  char dev[80];
  char mpoint[80];
  char fstype[80];
  char access[80];
  int  a,b;
  char result[1024];
  
  /* Alloc buffer space. 1k should be enough */
  edma_buffer_alloc (buf, 1024);
  /************************************************************
   ** We use /proc subfilesystem to get mount point list
   ** Maybe should be better to create a new class to manage
   ** /proc subsystem
   ******************************************************
   */
  if ((f = fopen ("/proc/mounts", "rt")) == NULL) 
    {
      printf ("%s", "Can't open /proc/mounts\n");
      return -1;
    }
  
  while (!feof (f)) 
    {
      fscanf (f, "%s %s %s %s %d %d",
	      dev,mpoint,fstype,access,&a,&b);
      if (strstr ("ext2vfatnfs", fstype) != 0) 
	{
	  sprintf (result, "%s\n", mpoint);
	  strcat ((EPChar)buf->dat, result);
	}
  }
  fclose (f);
  return 0;
}


ESint32 EDMAPROC 
FILESYSTEMGetFileSizeZrS32 (CLASSID id, EPChar name)
{
  struct stat buf;

  if ((stat (name, &buf))==-1) 
    {
      edma_printf ("%s", "Can't get file size");
      return -1;
    }
  return buf.st_size;
}


ESint32 EDMAPROC 
FILESYSTEMGetFileOwnerZsZrS32 (CLASSID id,EPChar name)
{
  struct stat buf;

  if ((stat (name, &buf)) == -1) 
    {
      edma_printf ("%s", "Can't get file owner");
      return -1;
    }
  
  return buf.st_uid;
}


ESint32 EDMAPROC 
FILESYSTEMTestFileZZrS32 (CLASSID id,EPChar name,EPChar flags)
{
  struct stat buf;
  
  /**
   ** WARNNING!!!!
   ** flags parameter has no efect at this moment
   ** flags will take the form of -X operator in shell and Perl scripts
   **
   ** At the moment this function simply test if a file exists
   **/
  if ((stat (name, &buf)) == -1) 
    {
      if (errno == ENOENT) 
	{
	  edma_printf ("File %s doesn't exist", name);
	  return 0;
	}

    edma_printf ("%s", "Can't get file info");
    perror ("[FILESYSTEM](TestFile):");
    return -1;
  }
  return 1; 
}


ESint32 EDMAPROC 
FILESYSTEMCreateDirectoryZrS32 (CLASSID id, EPChar name)
{
  int r;

  r = mkdir (name, 0777);
  return r;
}


ESint32 EDMAPROC 
FILESYSTEMDeleteDirectoryZrS32 (CLASSID id, EPChar name)
{
  return rmdir (name);
}


ESint32 EDMAPROC 
FILESYSTEMChangeDirectoryZrS32 (CLASSID id, EPChar name)
{
  return chdir (name);

}


ESint32 EDMAPROC 
FILESYSTEMReadRAWDirectoryZsArS32 (CLASSID id, EPChar dir_name,
				   EDMAT_BUFFER *buf)
{
  struct dirent   **namelist;
  ESint32         i, n;
  EPChar          *aux;
  
  /* We use scandir to know how many entry we have to alloc buf*/
  n = scandir (dir_name, &namelist, 0, alphasort);
  if (n < 0) 
    return -1;
  i = n;	
  edma_buffer_alloc (buf, (n + 1) * sizeof(EPChar));
  aux = (EPChar*) buf->dat;
  while (n--) 
    {
      edma_printf ("[FILESYSTEM] Dir entry : %s", namelist[n]->d_name);
      aux[n] = strdup (namelist[n]->d_name);
      free (namelist[n]);
    }
  aux[i] = NULL;   /* Set mark at the end of the buffer*/
  free (namelist);

  return 0;
}

ESint32 EDMAPROC 
FILESYSTEMFreeDirectoryDatasArS32 (CLASSID id, EDMAT_BUFFER *buf) 
{
  EPChar *aux;

  aux = (EPChar*) buf->dat;
  while (*aux != NULL) 
    {
      free (*aux);
      aux++;
    }	

  edma_buffer_free (buf);
  return 0;
}

ESint32 EDMAPROC 
FILESYSTEMReadDirectoryZsOrS32 (CLASSID id, OBJID *IdObj)
{
  edma_printf ("%s", "ReadDirectory still not implemented");
  /* This method will returno a DIRECTORY object*/
  return 0;
}


ESint32 EDMAPROC 
FILESYSTEMGetFileTimeZsS32sS32sS32rS32 (CLASSID id, EPChar name,
					ESint32 *at, ESint32 *mt, ESint32 *ct)
{
  struct stat buf;

  if ((stat(name, &buf)) == -1) 
    {
      edma_printf ("%s", "Can't get file time info");
      return -1;
    }

  *at = buf.st_atime;
  *mt = buf.st_mtime;
  *ct = buf.st_ctime;

  return 0;
}

/* IsXXX functions*/

ESint32 EDMAPROC 
FILESYSTEMIsDirectoryZrS32 (CLASSID id,EPChar name) 
{
  struct stat buf;
  
  if ((stat (name, &buf)) == -1) 
    {
      perror ("IsDirectort");
      return -1;
    }

  if (S_ISDIR(buf.st_mode))
    return 1;
  else
    return 0;
}

ESint32 EDMAPROC 
FILESYSTEMIsFileZrS32 (CLASSID id, EPChar name) 
{
  struct stat buf;

  if ((stat (name, &buf)) == -1) 
    {
      perror ("IsDirectort");
      return -1;
    }
  if (S_ISREG(buf.st_mode))
    return 1;
  else
    return 0;
}

ESint32 EDMAPROC 
FILESYSTEMIsLinkZrS32 (CLASSID id, EPChar name) 
{
  struct stat buf;
  
  if ((lstat (name, &buf)) == -1) 
    {
      perror ("IsDirectort");
      return -1;
    }
  if (S_ISLNK(buf.st_mode))
    return 1;
  else
    return 0;
}
/********** END C IMPLEMENTATION SKELETON ******************/
