/*
 * EDMA: Entorno de Desarrollo Modular y Abierto
 * Object Oriented and Componetware Framework
 * Copyright (C) 1998, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2010, 2013, 2021
 *    David Martnez Oliveira
 *
 * This file is part of EDMA.
 *
 * EDMA is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EDMA is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with EDMA.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.9.4
    (c) David Martnez Oliveira
    File generated by : EDMA C Implementation Builder class
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : VECTOR
    Description : Simple Vector Data Structure
    Author      : David Martnez Oliveira
    Date        : February, 19th, 2007
    Version     : 0.0
-----------------------------------------------------
  REVISIONS :
***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
 
/* Add here the includes you need for your class*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/*
***************************************************
  EDMA Header Files
***************************************************
*/
 
#include <edma.h>

/*
***************************************************
  Private Data Struct for class VECTOR
***************************************************
*/
 
typedef struct
{
  ESint32		capacity;
  ESint32		num_items;
  ESint32		size_items;
  EDMAT_BUFFER		items;
  EUint32		capacity_incr;
}DtVECTOR;
/*
***************************************************
  Method Declaration for class VECTOR
***************************************************
*/
 
ESint32 EDMAPROC
VECTORaddPrS32(OBJID IdObj, EPVoid data)
{
  DtVECTOR	*m;
  EPVoid        *item;

  m = (DtVECTOR *) edma_get_data_ref (IdObj);

  if (m->capacity == m->num_items)
    {
      /* Realocate data */
      m->capacity += m->capacity_incr;
      edma_buffer_realloc (&m->items, m->capacity * m->size_items);
    }
  item = (EPVoid *) m->items.dat;
  item[m->num_items] = data;
  m->num_items++;

  return 0;
}


ESint32 EDMAPROC
VECTORdelS32rS32(OBJID IdObj, ESint32 indx)
{
  DtVECTOR	*m;
  EPVoid        *item;

  m = (DtVECTOR *) edma_get_data_ref (IdObj);

  if ((indx < 0) || (indx > m->num_items - 1))
    {
      edma_printf_err ("[%s] Invalid index %d", __FUNCTION__, indx);
      return -1;
    }
  item = (EPVoid *) m->items.dat;

  item[indx] = NULL;

  /* XXX: Compact memory (Check this out) */
  memmove (&item[indx], &item[indx + 1], (m->num_items - indx - 1) * m->size_items);

  m->num_items--;
  return 0;
}


EPVoid EDMAPROC
VECTORgetS32rP(OBJID IdObj, ESint32 indx)
{
  DtVECTOR	*m;
  EPVoid        *item;

  m = (DtVECTOR *) edma_get_data_ref (IdObj);

  if ((indx < 0) || (indx > m->num_items - 1))
    {
      edma_printf_err ("[%s] Invalid index %d", __FUNCTION__, indx);
      return NULL;
    }
  item = (EPVoid *) m->items.dat;

  return item[indx];
}


ESint32 EDMAPROC
VECTORsetS32PrS32(OBJID IdObj, ESint32 indx, EPVoid data)
{
  DtVECTOR	*m;
  EPVoid        *item;

  m = (DtVECTOR *) edma_get_data_ref (IdObj);

  if ((indx < 0) || (indx > m->num_items - 1))
    {
      edma_printf_err ("[%s] Invalid index %d", __FUNCTION__, indx);
      return -1;
    }
  item = (EPVoid *) m->items.dat;
  item[indx] = data;

  return 0;
}


ESint32 EDMAPROC
VECTORclear(OBJID IdObj)
{
  DtVECTOR	*m;

  m = (DtVECTOR *) edma_get_data_ref (IdObj);

  if (m->num_items == 0)
    {
      edma_printf_err ("[%s] Vector is empty", __FUNCTION__);
      return -1;
    }

  m->num_items = 0;
  /* Upper levels are in charge of removing item memory before calling this method*/
  return 0;
}


ESint32 EDMAPROC
VECTORcreateS32rS32(OBJID IdObj, ESint32 capacity_incr)
{
  DtVECTOR	*m;

  m = (DtVECTOR *) edma_get_data_ref (IdObj);
  if (m->capacity != 0)
    {
      edma_printf_err ("[%s] Vector already initialised", __FUNCTION__);
      return -1;
    }
  if (capacity_incr < 0)
    {
      edma_printf_err ("[%s] Invalid capacity value. Must be > 0", __FUNCTION__);
      return -1;
    }

  m->capacity = m->capacity_incr = capacity_incr;
  edma_buffer_alloc (&m->items, m->size_items * m->capacity);
  
  return 0;
}


ESint32 EDMAPROC
VECTORget_n_itemsrS32(OBJID IdObj)
{
  DtVECTOR	*m;

  m = (DtVECTOR *) edma_get_data_ref (IdObj);

  return m->num_items;
}


ESint32 EDMAPROC
VECTORget_items_sizerS32(OBJID IdObj)
{
  DtVECTOR	*m;

  m = (DtVECTOR *) edma_get_data_ref (IdObj);

  return m->size_items;
}


ESint32 EDMAPROC
VECTORset_items_sizeU32rS32(OBJID IdObj, ESint32 size)
{
  DtVECTOR	*m;

  m = (DtVECTOR *) edma_get_data_ref (IdObj);

  if (m->num_items != 0)
    {
      edma_printf_err ("[%s] Cannot change item size on a populated array",  __FUNCTION__);
      return -1;
    }
  m->size_items = size;
  if (m->capacity != 0) /* Vector already allocated. Then realloc */
    edma_buffer_realloc (&m->items, m->size_items * m->capacity);

  return 0;
}


EDMAT_BUFFER EDMAPROC
VECTORget_itemsrA(OBJID IdObj)
{
  DtVECTOR	*m;

  m = (DtVECTOR *) edma_get_data_ref (IdObj);

  return m->items;
}


ESint32 EDMAPROC
VECTORget_capacityrS32(OBJID IdObj)
{
  DtVECTOR	*m;

  m = (DtVECTOR *) edma_get_data_ref (IdObj);

  return m->capacity;
}


ESint32 EDMAPROC
VECTORset_capacityS32rS32(OBJID IdObj, ESint32 cap)
{
  DtVECTOR	*m;

  m = (DtVECTOR *) edma_get_data_ref (IdObj);

  if (cap < m->num_items)
    {
      edma_printf_err ("[%s] Cannot reduce capacity beyond current vector size",
		       __FUNCTION__);
      return -1;
    }
  m->capacity = cap;
  edma_buffer_realloc (&m->items, m->size_items * m->capacity);

  return 0;
}


ESint32 EDMAPROC
VECTORborn(OBJID IdObj)
{
  DtVECTOR	*m;

  m = (DtVECTOR *) edma_get_data_ref (IdObj);

  m->capacity = 0;
  m->num_items = 0;
  m->capacity_incr = 10;
  m->size_items = sizeof(OBJID); /* By Default store GNU/EDMA objects*/

  return 0;
}

ESint32 EDMAPROC
VECTORrip(OBJID IdObj)
{
  DtVECTOR	*m;

  m = (DtVECTOR *) edma_get_data_ref (IdObj);

  edma_buffer_free (&m->items);

  return 0;
}


/******************************************************************************/

/* For local use Not required */
ESint32
VECTOR_class_factory ()
{
  CLASSID    cid;

  cid = edma_idf_get_free_class_id (EDMA_LOCAL_CLASS);

  edma_idf_set_class_name (cid, "VECTOR");
  
  edma_idf_set_class_namespace (cid, "system/data_structs");
  edma_idf_set_class_version (cid, 0, 0);
  
  edma_add_local_class_property (cid, "capacity", DT_ESINT32, E_L, 0);
  edma_add_local_class_property (cid, "num_items", DT_ESINT32, E_L, 0);
  edma_add_local_class_property (cid, "size_items", DT_ESINT32, E_L, 0);
  edma_add_local_class_property (cid, "items", DT_EBUFFER, E_L, 0);
  edma_add_local_class_property (cid, "capacity_incr", DT_EUINT32, E_L, 0);
  

 /* Method registration */
  edma_add_local_class_method (cid, "add", "PrS32", 
			       (PPROC)VECTORaddPrS32, 0, 0, 0);
  edma_add_local_class_method (cid, "del", "S32rS32", 
			       (PPROC)VECTORdelS32rS32, 0, 0, 0);
  edma_add_local_class_method (cid, "get", "S32rP", 
			       (PPROC)VECTORgetS32rP, 0, 0, 0);
  edma_add_local_class_method (cid, "set", "S32PrS32", 
			       (PPROC)VECTORsetS32PrS32, 0, 0, 0);
  edma_add_local_class_method (cid, "clear", "", 
			       (PPROC)VECTORclear, 0, 0, 0);
  edma_add_local_class_method (cid, "create", "S32rS32", 
			       (PPROC)VECTORcreateS32rS32, 0, 0, 0);
  edma_add_local_class_method (cid, "get_n_items", "rS32", 
			       (PPROC)VECTORget_n_itemsrS32, 0, 0, 0);
  edma_add_local_class_method (cid, "get_items_size", "rS32", 
			       (PPROC)VECTORget_items_sizerS32, 0, 0, 0);
  edma_add_local_class_method (cid, "set_items_size", "U32rS32", 
			       (PPROC)VECTORset_items_sizeU32rS32, 0, 0, 0);
  edma_add_local_class_method (cid, "get_items", "rA", 
			       (PPROC)VECTORget_itemsrA, 0, 0, 0);
  edma_add_local_class_method (cid, "get_capacity", "rS32", 
			       (PPROC)VECTORget_capacityrS32, 0, 0, 0);
  edma_add_local_class_method (cid, "set_capacity", "S32rS32", 
			       (PPROC)VECTORset_capacityS32rS32, 0, 0, 0);
  
  edma_idf_set_class_id (cid);

  return 0;
}


/********** END C IMPLEMENTATION SKELETON ******************/
