/*
 * EDMA: Entorno de Desarrollo Modular y Abierto
 * Object Oriented and Componetware Framework
 * Copyright (C) 1998, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2010, 2013, 2021
 *    David Martnez Oliveira
 *
 * This file is part of EDMA.
 *
 * EDMA is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EDMA is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with EDMA.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.9.4
    (c) David Martnez Oliveira
    File generated by : EDMA C Implementation Builder class
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : QUEUE
    Description : QUEUE class
    Author      : David Martnez Oliveira
    Date        : 7, March, 2007
    Version     : 0.0
-----------------------------------------------------
  REVISIONS :
***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
 
/* Add here the includes you need for your class*/

/*
***************************************************
  EDMA Header Files
***************************************************
*/
 
#include <edma.h>

/*
***************************************************
  Private Data Struct for class QUEUE
***************************************************
*/
 
typedef struct
{
	EUint32		head;
	EUint32		tail;
}DtQUEUE;
/*
***************************************************
  Method Declaration for class QUEUE
***************************************************
*/
 
/* Overrides vector add method */
ESint32 EDMAPROC
QUEUEaddPrS32(OBJID IdObj, EPVoid data)
{
  DtQUEUE	*m;

  m = (DtQUEUE *) edma_get_data_ref (IdObj);
  /* Adds item at the end of vector */
  edma_met3 (IdObj, "SUPER>add", data);
  m->tail = edma_met3 (IdObj, "get_n_items") - 1;
  return 0;
  
}

/* Overrides vector method . XXX: Changes parameters */
EPVoid EDMAPROC
QUEUEgetrP(OBJID IdObj) 
{ 
  DtQUEUE	*m;
  EPVoid        data;

  m = (DtQUEUE *) edma_get_data_ref (IdObj);

  if (m->tail == -1)
    {
      //edma_printf_obj (IdObj, "QUEUE is empty");
      return NULL;
    }
  data = (EPVoid) edma_met3 (IdObj, "SUPER>get", 0);
  if (data != NULL)
    edma_met3 (IdObj, "del", 0);

  m->tail = edma_met3 (IdObj, "get_n_items") - 1;
  return data;
}


EPVoid EDMAPROC
QUEUEpeekrP(OBJID IdObj)
{
  DtQUEUE	*m;
  EPVoid        data;

  m = (DtQUEUE *) edma_get_data_ref (IdObj);

  if (m->tail == -1)
    {
      //edma_printf_obj (IdObj, "QUEUE is empty");
      return NULL;
    }
  data = (EPVoid) edma_met3 (IdObj, "SUPER>get", 0);

  return data;
}


ESint32 EDMAPROC
QUEUEborn(OBJID IdObj)
{
  DtQUEUE	*m;

  m = (DtQUEUE *) edma_get_data_ref (IdObj);

  m->head = m->tail = -1;

  return 0;
}


ESint32 EDMAPROC
QUEUErip(OBJID IdObj)
{
  DtQUEUE	*m;
  
  m = (DtQUEUE *) edma_get_data_ref (IdObj);
  return 0;
}


ESint32
QUEUE_class_factory ()
{
CLASSID    cid;

cid = edma_idf_get_free_class_id (EDMA_LOCAL_CLASS);

edma_idf_set_class_name (cid, "QUEUE");

edma_idf_set_class_namespace (cid, "system/data_structs");
edma_idf_set_class_version (cid, 0, 0);

edma_add_local_class_property (cid, "head", DT_EUINT32, E_L, 0);
edma_add_local_class_property (cid, "tail", DT_EUINT32, E_L, 0);

	/*UNKNOW ()*/
	/*UNKNOW ()*/
	/*UNKNOW ()*/
 /* Method registration */
edma_add_local_class_method (cid, "add", "PrS32", (PPROC)QUEUEaddPrS32, 0, 0, 0);
edma_add_local_class_method (cid, "get", "rP", (PPROC)QUEUEgetrP, 0, 0, 0);
edma_add_local_class_method (cid, "peek", "rP", (PPROC)QUEUEpeekrP, 0, 0, 0);
edma_add_local_class_method (cid, "born", "", (PPROC)QUEUEborn, 0, 0, 0);
edma_add_local_class_method (cid, "rip", "", (PPROC)QUEUErip, 0, 0, 0);

edma_idf_set_class_id (cid);

return 0;
}


/********** END C IMPLEMENTATION SKELETON ******************/
