/*
 * EDMA: Entorno de Desarrollo Modular y Abierto
 * Object Oriented and Componetware Framework
 * Copyright (C) 1998, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2010, 2013, 2021
 *    David Martnez Oliveira
 *
 * This file is part of EDMA.
 *
 * EDMA is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EDMA is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with EDMA.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.5.1r1
    (c) David Martnez Oliveira
    File generated by : EDMA IDF Wizard Gnomized 0.1
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : EDMA_MAKE_BUILDER
    Description : Build make file for building EDMA class defined through 
                  CLASS_METADATA objects
    Author      : David Martnez Oliveira
    Date        : 26/02/2000
-----------------------------------------------------
  REVISIONS :
  July, 15th, 2001
  Adding clean rule to makefiles
  * November, 17th, 2001
  * Changed to generate libCLASS.so
  * This Class is not tested and probably it'll be removed from
  * basic distribution
***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
 
#include <stdio.h>
#include <string.h>

/*
***************************************************
  EDMA Header Files
***************************************************
*/
 
#include <edma.h>
 
/*
***************************************************
  Method Declaration for class 
***************************************************
*/
 
ESint32 EDMAPROC 
EDMA_MAKE_BUILDERbuildU32Z (OBJID IdObj,OBJID id,EPChar fname)
{
  FILE      *f;
  EChar     temp[1024];
  EChar     ns[1024];

  f=fopen(fname,"wt");
  if (f==NULL) 
    {
      edma_printf_obj (IdObj,"Can't Open file %s for writting",fname);
      return 1;
    }
  edma_rprop3 (id,"ClassName",temp);
  fprintf (f, "#\n"
	   "#   Copyright (C) YEAR\n"
	   "#             by Author\n"
	   "#\n"
	   "#   This program is free software: you can redistribute it and/or modify\n"
	   "#   it under the terms of the GNU General Public License as published by\n"
	   "#   the Free Software Foundation, either version 3 of the License, or\n"
	   "#   (at your option) any later version.\n"
	   "#\n"
	   "#   This program is distributed in the hope that it will be useful,\n"
	   "#   but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
	   "#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
	   "#   GNU General Public License for more details.\n"
	   "#\n"
	   "#   You should have received a copy of the GNU General Public License\n"
	   "#   along with this program.  If not, see <http://www.gnu.org/licenses/>.\n"
	   "#\n"
	   );

  fprintf (f,"#");
  fprintf (f,"\n# Makefile for EDMA class %s",temp);
  fprintf (f,"\n# Generated by EDMA_MAKE_BUILDER 0.1");
  fprintf (f,"\n#");
  fprintf (f,"\nCC=gcc");
  fprintf (f,"\nCCFLAGS=`edma-config --cflags-class`");
  fprintf (f,"\nLIBS=`edma-config --libs-class` ");

  edma_rprop3 (id, "NameSpace", ns);

  fprintf (f,"\nNAMESPACE = %s", ns);
  fprintf (f, "\nTARGET_DIR = `edma-config --dir-impl`/edma/${NAMESPACE}"
	   "\bIDF_DIR = `edma-config --dir-int`/${NAMESPACE}");
  fprintf (f,"\n");
  fprintf (f,"\nlib%s.so: temp.o ",temp);
  fprintf (f,"\n\t$(CC) -nostartfiles -shared -Wl,-soname,lib%s.so.1 -o $@ temp.o $(LIBS) ",temp); 
  fprintf (f,"\n");
  fprintf (f,"\ntemp.o: %s_imp.c ",temp);
  fprintf (f,"\n	$(CC)  $(CCFLAGS) $< -o $@ ");
  fprintf (f,"\n");
  fprintf (f,"\n");
  fprintf (f,"\n.PHONY: install");
  fprintf (f,"\ninstall:");
  fprintf (f,"\n\tcp lib%s.so `edma-config --dir-impl`",temp);
  fprintf (f,"\n\tcp %s.idf `edma-config --dir-int`",temp);
  fprintf (f, "\n\tln -s ${TARGET_DIR}/lib%s.so.0.0.0 ${TARGET_DIR}/lib%s.so.0", temp, temp);
  fprintf (f, "\n\tln -s ${TARGET_DIR}/lib%s.so.0.0.0 ${TARGET_DIR}/lib%s.so", temp, temp);

  fprintf (f,"\n");
  fprintf (f,"\n.PHONY: clean");
  fprintf (f,"\nclean:");
  fprintf (f,"\n\trm -f lib%s.so *~ *.o core\n",temp);

  fprintf (f,"\n");  

  fclose (f);
  return 0;
}



/********** END C IMPLEMENTATION SKELETON ******************/
