/*
 * EDMA: Entorno de Desarrollo Modular y Abierto
 * Object Oriented and Componetware Framework
 * Copyright (C) 1998, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2010, 2013, 2021
 *    David Martnez Oliveira
 *
 * This file is part of EDMA.
 *
 * EDMA is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EDMA is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with EDMA.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.5.1r1
    (c) David Martnez Oliveira
    File generated by : EDMA IDF Wizard Gnomized 0.1
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : EDMAIDF_BUILDER
    Description : Build EDMA IDF files from a CLASS_METADATA Object
    Author      : David Martnez Oliveira
    Date        : 26/02/2000
-----------------------------------------------------
REVISIONS :
July, 20th, 2002
Modification to store Version information in IDF files
***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
 
#include <stdio.h>
#include <string.h>

/*
***************************************************
  EDMA Header Files
***************************************************
*/
 
#include <edma.h>

/*
***************************************************
  Private Data Struct for class EDMAIDF_BUILDER
***************************************************
*/
 
typedef struct
  {
     EPChar		FileName;
     EUint32		h;
}DtEDMAIDF_BUILDER;

/*
***************************************************
  Method Declaration for class EDMAIDF_BUILDER
***************************************************
*/
 
ESint32 EDMAPROC 
EDMAIDF_BUILDERbuildU32Z (OBJID IdObj,OBJID id,EPChar filename)
{
  DtEDMAIDF_BUILDER	*m;
  FILE                  *f;
  EChar                 temp[256], temp1[256], temp2[256];
  EUint32               i, j, n;
  EUint32               m_virtual, m_abstract, m_static;
  ESint32               aux;
  
  m = (DtEDMAIDF_BUILDER *) edma_get_data_ref (IdObj);

  /* Open file to write down */
  edma_printf_obj (IdObj, "Opening file %s", filename);
  f = fopen (filename, "wt");
  if (f == NULL) 
    {
      edma_printf_obj(IdObj, "Can't open file %s for writting", filename);
      return -1;
    }

  /* Writting license */
  fprintf (f, ";\n"
	   ";   Copyright (C) YEAR\n"
	   ";             by Author\n"
	   ";\n"
	   ";   This program is free software: you can redistribute it and/or modify\n"
	   ";   it under the terms of the GNU General Public License as published by\n"
	   ";   the Free Software Foundation, either version 3 of the License, or\n"
	   ";   (at your option) any later version.\n"
	   ";\n"
	   ";   This program is distributed in the hope that it will be useful,\n"
	   ";   but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
	   ";   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
	   ";   GNU General Public License for more details.\n"
	   ";\n"
	   ";   You should have received a copy of the GNU General Public License\n"
	   ";   along with this program.  If not, see <http://www.gnu.org/licenses/>.\n"
	   ";\n"
	   );

  /* Writting General Secction */
  edma_printf_obj (IdObj, "Writting General Section");
  fprintf (f, "[General]");
  edma_printf_obj (IdObj, "Ready to read ClassName");
  edma_rprop3 (id, "ClassName", temp);
  edma_printf_obj (IdObj, "ClassName: %s", temp);
  fprintf (f, "\nName=%s", temp);

  fprintf (f, "\n[SYS_DEF]");
  edma_rprop3 (id, "ModuleName", temp);
  fprintf (f, "\nModuleName=%s", temp);
  edma_rprop3 (id, "NameSpace", temp);
  fprintf (f, "\nNameSpace=%s", temp);

  /* Versioning Information*/
  edma_rprop3 (id, "MajorVersion", &aux);
  fprintf (f, "\nMajorVer=%ld", aux);
  edma_rprop3 (id, "MinorVersion", &aux);
  fprintf (f, "\nMinorVer=%ld", aux);

  fprintf (f, "\n[Definition]");
  edma_rprop3 (id, "nProp", &n);
  fprintf (f, "\nPropertiesNum=%ld", n);
  edma_rprop3 (id, "nMet", &n);
  fprintf (f, "\nMethodsNum=%ld", n);
  edma_rprop3 (id, "nSC", &n);

  edma_printf_obj (IdObj, "Processing %d Superclasses", n);
  if (n)
    {
      fprintf (f, "\nSCList=");
       if (n > 0)
	{
	  edma_met3 (id, "GetSC", 0, temp);
	  fprintf (f, "%s", temp);      
	}
      for (i = 1; i < n; i++)
	{
	  edma_met3 (id, "GetSC", i, temp);
	  fprintf (f, ",%s", temp);
	}
    }
  /* Properties */
  edma_rprop3 (id, "nProp", &n);
  edma_printf_obj (IdObj, "Processing %d properties", n);
  for (i = 0; i < n;i++)
    {
      fprintf (f, "\n[Prop%ld]", i);
      edma_met3 (id, "GetProp", i, temp, temp1, temp2, &j);
      edma_printf_obj (IdObj, "Writing Prop %d: %s|%s|%s|%d",
		       i, temp, temp1, temp2, j);
      fprintf (f, "\nName=%s", temp);
      fprintf (f, "\nType=%s", temp1);
      fprintf (f, "\nAccess=%s", temp2);
      fprintf (f, "\nArrayElems=");
      if (j)
	fprintf (f, "%ld", j);
    }

  /* Methods */
  edma_rprop3 (id, "nMet", &n);
  edma_printf_obj (IdObj, "Processing %d Methods", n);
  for (i = 0; i < n;i++)
    {
      fprintf (f, "\n[Met%ld]", i);
      edma_met3 (id, "GetMet",
		 i, temp, temp1, &m_virtual, &m_abstract, &m_static);
      edma_printf_obj (IdObj, "Method %d: %s|%s|%d\%d\%d", 
		       i, temp, temp1, m_virtual, m_abstract, m_static);

      fprintf (f, "\nName=%s", temp);
      fprintf (f, "\nSignature=%s", temp1);
      fprintf (f, "\nVirtual=%ld", m_virtual);

      if (m_abstract)
	fprintf (f, "\nAbstract=%ld", m_abstract);
      if (m_static)
	fprintf (f, "\nStatic=%ld", m_static);
    }
  
  fprintf (f, "\n[]\n");

  fclose (f);
  return 0;
}

