/*
 This file is part of GNU Taler
 (C) 2022 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Sebastian Javier Marchano (sebasjm)
 */

import { TranslatedString } from "@gnu-taler/taler-util";
import * as tests from "../../tests/hook.js";
import { DefaultForm as TestedComponent } from "../forms-ui.js";
import { FormDesign, UIHandlerId } from "../forms-types.js";

export default {
  title: "Input File",
};

export namespace Simplest {
  export interface Form {
    comment: string;
  }
}

type TargetObject = {
  pdf?: string;
};
const initial: TargetObject = {
  pdf: "file:CONTRATO DE LOCACIÓN DE VIVIENDA BULNES.docx.pdf;data:application/pdf;base64,JVBERi0xLjQKJdPr6eEKMSAwIG9iago8PC9UaXRsZSA8RkVGRjAwNDMwMDRGMDA0RTAwNTQwMDUyMDA0MTAwNTQwMDRGMDAyMDAwNDQwMDQ1MDAyMDAwNEMwMDRGMDA0MzAwNDEwMDQzMDA0OTAwRDMwMDRFMDAyMDAwNDQwMDQ1MDAyMDAwNTYwMDQ5MDA1NjAwNDkwMDQ1MDA0RTAwNDQwMDQxMDAyMDAwNDIwMDU1MDA0QzAwNEUwMDQ1MDA1MzAwMkUwMDY0MDA2RjAwNjMwMDc4PgovUHJvZHVjZXIgKFNraWEvUERGIG0xMzQgR29vZ2xlIERvY3MgUmVuZGVyZXIpPj4KZW5kb2JqCjMgMCBvYmoKPDwvY2EgMQovQk0gL05vcm1hbD4+CmVuZG9iago3IDAgb2JqCjw8L0ZpbHRlciAvRmxhdGVEZWNvZGUKL0xlbmd0aCAxMDMxNT4+IHN0cmVhbQp4nMVd3Y4muW29n6foF9ha/f8AhoHpnh0jFwbiYN8gjg0EyEWc9wciSqKqSlJ1fRRrZr1o90zvtr5TKkmkSJ5D+SbSP7/I9H/BqLf//J8v//tl8zb/FL+nH8o3+Oc//vJW/vCvf3759S/67Z//9wX+vY/mTUql3/71X1/+8eVv3QjBbsIKIfSbF1swMcYAI4r8H6QRyx/2EX/997c//enXv37827f04z//+f3bx5f337/8+j19hnv7/R9fJCK2cTPW6LfNKm10+qTfYdRfpNlMKH//+9ufhFAufbZKXzJ9+fSVwCjz57ff//uL85sCoOU/1D7/MOKvt5+r/PPffifgCHGTProQRjxC04eLenMJ6fhs6XlUoI8npd2CldbpZ/BJJTaVHtfPMH4v8w/vQZn6/UOID/i5pH+WEnY+GSvAlRSb8AnHc3OrtMpz8dCrV9pt3igZx+F0LDOJ31UoqzwjN/SP0lJt6",
};

const design: FormDesign = {
  type: "double-column",
  sections: [
    {
      title: "this is a simple form" as TranslatedString,
      fields: [
        {
          type: "file",
          label: "PNG files" as TranslatedString,
          required: true,
          id: "png",
          accept: ".png",
          tooltip:
            "this is a very long tooltip that explain what the field does without being short" as TranslatedString,
          help: "Max size of 2 mega bytes" as TranslatedString,
        },
        {
          type: "file",
          label: "PDF files" as TranslatedString,
          required: true,
          id: "pdf",
          accept: ".pdf",
          tooltip:
            "this is a very long tooltip that explain what the field does without being short" as TranslatedString,
          help: "Max size of 2 mega bytes" as TranslatedString,
        },
      ],
    },
  ],
};

export const TestingAccept = tests.createExample(TestedComponent, {
  initial,
  design,
});
