import { Fragment, h, VNode } from "preact";
import {
  DebugInfo,
  Notification,
  useCommonPreferences,
} from "../index.browser.js";
import { Attention } from "./Attention.js";

export function LocalNotificationBanner({
  notification,
}: {
  notification?: Notification;
}): VNode {
  if (!notification) return <Fragment />;
  switch (notification.message.type) {
    case "error":
      return (
        <div class="relative">
          <div class="fixed top-0 left-0 right-0 z-20 w-full p-4">
            <Attention
              type="danger"
              title={notification.message.title}
              onClose={() => {
                notification.acknowledge();
              }}
            >
              {notification.message.description && (
                <div class="mt-2 text-sm text-red-700">
                  {notification.message.description}
                </div>
              )}
              <DebugInfo error={notification.message.debug} />
            </Attention>
          </div>
        </div>
      );
    case "info":
      return (
        <div class="relative">
          <div class="fixed top-0 left-0 right-0 z-20 w-full p-4">
            <Attention
              type="success"
              title={notification.message.title}
              onClose={() => {
                notification.acknowledge();
              }}
            />
          </div>
        </div>
      );
  }
}

export function LocalNotificationBannerBulma({
  notification,
}: {
  notification?: Notification;
}): VNode {
  if (!notification) return <Fragment />;
  const msg = notification.message;
  const [{ showDebugInfo }] = useCommonPreferences();
  switch (msg.type) {
    case "error":
      return (
        <div style={{ position: "relative" }}>
          <div
            style={{
              position: "fixed",
              zIndex: 99,
              top: 0,
              left: 0,
              right: 0,
              width: "100%",
            }}
          >
            <div class="notification">
              <div class="columns is-vcentered">
                <div class="column is-12">
                  <article class="message is-danger">
                    <div class="message-header">
                      <p>{msg.title}</p>
                      <button
                        class="delete "
                        aria-label="close"
                        onClick={() => notification.acknowledge()}
                      />
                    </div>
                    {msg.description && (
                      <div class="message-body">
                        <div>{msg.description}</div>
                        {showDebugInfo && msg.debug && (
                          <pre> {JSON.stringify(msg.debug, undefined, 2)}</pre>
                        )}
                      </div>
                    )}
                  </article>
                </div>
              </div>
            </div>
          </div>
        </div>
      );
    case "info":
      return (
        <div style={{ position: "relative" }}>
          <div
            style={{
              position: "fixed",
              zIndex: 99,
              top: 0,
              left: 0,
              right: 0,
              width: "100%",
            }}
          >
            <div class="notification">
              <div class="columns is-vcentered">
                <div class="column is-12">
                  <article class="message is-info">
                    <div class="message-header">
                      <p>{msg.title}</p>
                    </div>
                  </article>
                </div>
              </div>
            </div>
          </div>
        </div>
      );
  }
}
