/*
 This file is part of GNU Taler
 (C) 2022-2024 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
import { default as tw_typo } from '@tailwindcss/typography';
import { default as tw_form } from '@tailwindcss/forms';

export default {
  content: {
    relative: true,
    files: [
      "./src/**/*.{html,tsx}",
      "./node_modules/@gnu-taler/web-util/src/**/*.{html,tsx}"
    ],
  },
  theme: {
    extend: {
      colors: {
        // https://docs.taler.net/design-documents/066-wallet-color-scheme.html

        // PRIMARY 
        /**
         * Main action color (e.g. filled buttons, tabs, icons)
         */
        'primary': '#0042b3',
        /**
         * Text/icons placed on top of primary
         */
        'onPrimary': '#ffffff',
        /**
         * Background for FABs, cards, filled fields
         */
        'primaryContainer': '#d3deff',
        /**
         * Foreground for primaryContainer
         */
        'onPrimaryContainer': '#00134a',
        /**
         * primary in dark mode
         */
        'darkPrimary': '#b4c5ff',
        /**
         * Text/icons on darkPrimary
         */
        'darkOnPrimary': '#002a78',
        /**
         * Container in dark mode
         */
        'darkPrimaryContainer': '#0042b3',
        /**
         * Foreground on container in dark
         */
        'darkOnPrimaryContainer': '#e5ebff',

        // SECONDARY 
        /**
        * Secondary buttons, chips, and passive UI states
        */
        'secondary': '#586a88',
        /**
         * Foreground on secondary
         */
        'onSecondary': '#ffffff',
        /**
         * Background for secondary surfaces
         */
        'secondaryContainer': '#d9e3f9',
        /**
         * Foreground on secondaryContainer
         */
        'onSecondaryContainer': '#111c2b',
        /**
         * Secondary color in dark mode
         */
        'darkSecondary': '#a4c9ff',
        /**
         * Text/icons on darkPrimary
         */
        'darkOnSecondary': '#00315d',
        /**
         * Container in dark mode
         */
        'darkSecondaryContainer': '#72a3e5',
        /**
         * Foreground on container in dark
         */
        'darkOnSecondaryContainer': '#003869',
      },

      // TERTIARY 
      /**
      * Used for tags, emphasis markers
      */
      'tertiary': '#338af0',
      /**
       * Text/icons on tertiary
       */
      'onTertiary': '#ffffff',
      /**
       * Input field backgrounds, selected indicators
       */
      'tertiaryContainer': '#d1e4ff',
      /**
       * Text/icons on tertiaryContainer
       */
      'onTertiaryContainer': '#001c39',
      /**
       * Accent color in dark mode
       */
      'darkTertiary': '#8dd1e5',
      /**
       * Foreground in dark
       */
      'darkOnTertiary': '#003641',
      /**
       * Container fill in dark
       */
      'darkTertiaryContainer': '#166577',
      /**
       * Text/icons on dark container
       */
      'darkOnTertiaryContainer': '#9ce0f5',

      // ERROR
      /**
      * Main error color for messages or outlines
      */
      'error': '#b3261e',
      /**
      * Text/icons on error surfaces
       */
      'onError': '#ffffff',
      /**
      * 
       */
      'errorContainer': '#f9dedc',
      /**
      * 
       */
      'onErrorContainer': '#410e0b',
      /**
      * 
       */
      'darkError': '#ffb4aa',
      /**
      * 
       */
      'darkOnError': '#690003',
      /**
      * 
       */
      'darkErrorContainer': '#b3261e',
      /**
      * 
       */
      'darkOnErrorContainer': '#ffcbc4',

      // SUCCESS
      /**
      * 
      */
      'success': '#337a40',
      /**
      * 
       */
      'onSuccess': '#ffffff',
      /**
      * 
       */
      'successContainer': '#2e8534',
      /**
      * 
       */
      'onSuccessContainer': '#f7fff1',
      /**
      * 
       */
      'darkSuccess': '#337a40',
      /**
      * 
       */
      'darkOnSuccess': '#ffffff',
      /**
      * 
       */
      'darkSuccessContainer': '#1d3522',
      /**
      * 
       */
      'darkOnSuccessContainer': '#eaf6ec',

      // WARNING
      /**
      * Alert banners, passive warnings
      */
      'warning': '#f99c06',
      /**
      * 
       */
      'onWarning': '#000000',
      /**
      * 
       */
      'warningContainer': '#fdedd3',
      /**
      * 
       */
      'onWarningContainer': '#6b4706',
      /**
      * 
       */
      'darkWarning': '#f99c06',
      /**
      * 
       */
      'darkOnWarning': '#000000',
      /**
      * 
       */
      'darkWarningContainer': '#664200',
      /**
      * 
       */
      'darkOnWarningContainer': '#fdedd3',

      // BACKGROUND
      /**
      * App-wide background color
      */
      'background': '#fdfdff',
      /**
      * 
       */
      'onBackground': '#1a1c1f',
      /**
      * Background in dark mode
       */
      'darkBackground': '#11131a',
      /**
      * 
       */
      'darkOnBackground': '#e2e2eb',

      // OUTLINE
      /**
      * Used for input borders, field outlines
      */
      'outline': '#767880',
      /**
      * Decorative borders, dividers
       */
      'outlineVariant': '#c4c6d0',

    },
  },
  plugins: [tw_typo, tw_form],
};
